<?php

namespace Mtc\Core\Admin;

use \Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Category;

/**
 * Admin\User class.  This looks after the admin_users table 
 * using Eloquent base modelling
 *
 * @author william.cameron
 */
class UserAllowedCategories extends Model
{

    protected $table = "admin_user_allowed_categories";

    protected $fillable = [
        'category_id',
        'user_id'
    ];

    /**
     * Relationship to admin user
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Relationship to the restricted category
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

}
