<?php
namespace Mtc\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class SeoDefault extends Model
{
    protected $table = 'seo_defaults';
    public $timestamps = false;

    protected $fillable = [
        'name',
        'path',
        'title',
        'description',
    ];

    /**
     * Boot method to clear SEO cache when data changes
     */
    protected static function boot()
    {
        parent::boot();

        // Clear all SEO cache when defaults change (affects fallback logic)
        // Since defaults affect multiple pages, we flush all cache
        static::saved(function () {
            Cache::flush();
        });

        static::deleted(function () {
            Cache::flush();
        });
    }
}
