<?php
namespace Mtc\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class SeoPage extends Model
{
    protected $table = 'seo_pages';
    public $timestamps = false;

    protected $fillable = [
        'path',
        'title',
        'description',
    ];

    /**
     * Boot method to clear SEO cache when data changes
     */
    protected static function boot()
    {
        parent::boot();

        // Clear cache after creating, updating, or deleting
        static::saved(function ($model) {
            self::clearSeoCache($model->path);
        });

        static::deleted(function ($model) {
            self::clearSeoCache($model->path);
        });
    }

    /**
     * Clear SEO cache for a specific path
     * Works with file-based caching by clearing the specific cache key
     *
     * @param string $path
     */
    protected static function clearSeoCache($path)
    {
        // Clear cache for the specific path
        $cache_key = 'seo_data_' . md5($path);
        Cache::forget($cache_key);

        // Note: File-based cache doesn't support tags, so we clear specific keys
        // If you need to clear all SEO cache, use: Cache::flush()
    }
}
