<?php

namespace Mtc\Core;

/**
 * Makes sure custom fonts are loaded in vendor dir
 *
 * @author  Uldis Zvirbulis
 * @version 19.03.2019.
 */
class TCPDFWithCustomFonts extends \TCPDF
{
    /**
     * Path to where the custom fonts are located
     */
    const CUSTOM_FONTS_PATH = SITE_PATH . '/core/fonts/tcpdf';

    /**
     * Path to where the TCPDF fonts are located
     */
    const TCPDF_FONTS_PATH = SITE_PATH . '/vendor/tecnickcom/tcpdf/fonts';

    /**
     * Constructor with additional implementations
     *
     * TCPDFWithCustomFonts constructor.
     * @param string $orientation
     * @param string $unit
     * @param string $format
     * @param bool $unicode
     * @param string $encoding
     * @param bool $diskcache
     * @param bool $pdfa
     */
    public function __construct(string $orientation = 'P', string $unit = 'mm', string $format = 'A4', bool $unicode = true, string $encoding = 'UTF-8', bool $diskcache = false, bool $pdfa = false)
    {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);

        $files = scandir(self::CUSTOM_FONTS_PATH);
        if (is_array($files)) {
            foreach ($files as $file) {
                if ($file === '.' || $file === '..') {
                    continue;
                }
                copy(self::CUSTOM_FONTS_PATH . '/' . $file, self::TCPDF_FONTS_PATH . '/' . $file);
            }
        }

    }
}
