<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Shop\Item;
use Mtc\Shop\Item\Size;
use Mtc\Shop\Order\Item as OrderItem;
use Mtc\Shop\Order;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class OrderItemsFactory extends Factory
{
    protected $model = OrderItem::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $item = Item::inRandomOrder()->first();

        return [
            'item_id' => $item->id,
            'has_requested_subscription' => 0,
            'assessment_id' => 0,
            'item_name' => $item->name,
            'item_price' => $item->price,
            'quantity' => 1,
            'size' => 'One Size',
            'sizeid' => 0,
            'PLU' => '',
            'timestamp' => now(),
            'price_paid' => $item->price,
            'price_paid_exvat' => $item->price_exvat,
        ];
    }
}
