<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class IngredientsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        echo 'Seeding ingredients...' . PHP_EOL;

        DB::table('ingredients')->delete();
        
        DB::table('ingredients')->insert(array (
            0 => 
            array (
                'id' => '6',
                'name' => 'Opiate',
                'limit_period' => '28',
                'limit_amount' => '1',
                'limit_order' => '1',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Contains Codeine or Dihydrocodeine.&nbsp;</p>
<p>Limit 1 box every 28 days</p>',
            ),
            1 => 
            array (
                'id' => '7',
                'name' => 'Aerosol',
                'limit_period' => '0',
                'limit_amount' => '0',
                'limit_order' => '2',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Max. Limit 2 Aersols per Order</p>',
            ),
            2 => 
            array (
                'id' => '8',
                'name' => 'Paracetamol',
                'limit_period' => '1',
                'limit_amount' => '0',
                'limit_order' => '96',
                'limit_once' => '0',
                'limit_type' => 'tablets',
                'message' => '<p>Contains Paracetamol.</p>
<p>Max Limit 96 tablets.</p>',
            ),
            3 => 
            array (
                'id' => '9',
                'name' => 'Aspirin',
                'limit_period' => '1',
                'limit_amount' => '1',
                'limit_order' => '96',
                'limit_once' => '0',
                'limit_type' => 'tablets',
                'message' => '<p>Contains Aspirin.</p>
<p>Max. Limit 100 tabs</p>',
            ),
            4 => 
            array (
                'id' => '10',
                'name' => 'Stimulant Laxative',
                'limit_period' => '30',
                'limit_amount' => '2',
                'limit_order' => '2',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Contains a Stimulant Laxative</p>
<p>Max Limit 60 tablets</p>
<p>&nbsp;</p>',
            ),
            5 => 
            array (
                'id' => '11',
                'name' => 'Sedative',
                'limit_period' => '28',
                'limit_amount' => '2',
                'limit_order' => '2',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Contains a Sedative</p>
<p>Max Limit. 1 box</p>',
            ),
            6 => 
            array (
                'id' => '12',
                'name' => 'Pseudoephedrine',
                'limit_period' => '28',
                'limit_amount' => '6',
                'limit_order' => '1',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Contains Pseudoephedrine</p>
<p>Max Limit 1 box</p>',
            ),
            7 => 
            array (
                'id' => '13',
                'name' => 'Dry Cough',
                'limit_period' => '15',
                'limit_amount' => '1',
                'limit_order' => '2',
                'limit_once' => '0',
                'limit_type' => 'boxes',
                'message' => '<p>Contains Dextromethorphan</p>
<p>Max Limit: 2 items</p>
<p>&nbsp;</p>',
            ),
        ));
        
        
    }
}