<?php

namespace Mtc\Modules\BasketRecovery\Classes;

use Mtc\Plugins\NHS\Classes\Reminder;

$path = '../../../';
require_once $path.'core/includes/header.inc.php';
$page_meta['title'] = 'NHS Follow-Up Log';

ob_start();
require __DIR__ . '/templates/tabnav.php';
$tab_nav = ob_get_clean();

$upcoming = Reminder::query()
    ->whereNotNull('sent_at')
    ->orderBy('sent_at', 'desc')
    ->take(150)
    ->with([
        'order',
        'orderItem',
        'member'
    ])
    ->get();

$twig->display('Modules/BasketRecovery/upcoming.twig', [
    'page_meta' => $page_meta,
    'tabnav' => $tab_nav,
    'upcoming' => $upcoming,
]);