<?php

$path = '../../../';
require $path.'core/includes/header.inc.php';

use Mtc\Modules\BasketRecovery\Classes\BasketRecoveryEmail as Email;
use Mtc\Modules\BasketRecovery\Classes\BasketRecoveryLog as Log;

// If the data doesn't match, then take 'em back to the homepage.
if (!isset($_GET['id']) || !isset($_GET['hash']) || $_GET['hash'] != Email::generateRecoveryHash($_GET['id'] . '_' . $_GET['recovery_id'])) {
    header('Location: /');
    exit();
}

// All is good, so re-build the basket!
$basket_id = (int) $_GET['id'];
$basket = new Basket($basket_id);
$_SESSION['basket_id'] = $basket->id;

// Insert a record in the log that this has been clicked on
Log::insert([
    'basket_recovery_id' => $_GET['recovery_id'],
    'basket_id' => $basket_id,
    'action' => 'click',
    'value' => null,
    ]);

header('Location: /shop/checkout/basket.php');
