<?php
/**
 * Admin section for form list and removal
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Modules\FormBuilder\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
require_once '../includes/install.php';
$page_meta['title'] = 'Manage Site Forms';

if (isset($_REQUEST['action'])
    && $_REQUEST['action'] == 'delete'
    && isset($_REQUEST['delete_id'])
) {
    Form::destroy($_REQUEST['delete_id']);
    $message = 'Form deleted';
}


if (!empty($_REQUEST['action'])
    && !empty($_REQUEST['update_id'])
    && $_REQUEST['action'] == 'change_published'
    && $_REQUEST['update_id'] > 0
) {

    $block = Form::find($_REQUEST['update_id']);
    if (isset($_REQUEST['value']) && in_array($_REQUEST['value'], [0, 1])) {
        $block->published = (int) $_REQUEST['value'];
        $block->save();
        $message = 'Form changed';
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage Forms</li>
</ul>

<h1>Manage Site Forms</h1>

<?php
require 'tabnav.php';

if (!empty($message) && isset($_REQUEST['action'])) {
    echo showmsg($message, "success", $path);
}

$forms = Form::orderBy('id', 'DESC')->get();
if (count($forms) > 0) {
    ?>
    <table class="manage-items">
        <tr>
            <th>Form ID</th>
            <th>Form Name</th>
            <th class="center">Preview</th>
            <th class="center">Active</th>
            <th class="center">Displayed until</th>
            <th class="center">Responses (in DB)</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular">

            <?php
            $donotdelete = array();
            foreach ($forms as $form) {
                ?>
                <tr>
                    <td>
                        <a href="edit.php?id=<?= clean_page($form->id); ?>">
                            <?= clean_page($form->id); ?>
                        </a>
                    </td>
                    <td>
                        <a href="edit.php?id=<?= clean_page($form->id); ?>">
                            <?= clean_page($form->name); ?>
                        </a>
                    </td>
                    <td class="center">
                        <a href="/modules/FormBuilder/render.php?id=<?= clean_page($form->id) ?>"
                            target="_blank">
                            <i class="fa fa-eye"></i>
                        </a>
                    </td>
                    <td class="center">
                        <?php
                        if ($form->published) {
                            $params = [
                                'action' => 'change_published',
                                'value' => 0,
                                'update_id' => $form->id,
                            ];
                            ?>
                            <a href="index.php?<?= http_build_query($params) ?>"
                                    class="alert error"
                                    title="Are you sure you want to unpublish this form?">
                                <i class="fa fa-check"></i>
                            </a>
                            <?php
                        } else {
                            $params = [
                                'action' => 'change_published',
                                'value' => 1,
                                'update_id' => $form->id,
                            ];
                            ?>
                            <a href="index.php?<?= http_build_query($params) ?>">
                                <i class="fa fa-square-o"></i>
                            </a>
                            <?php
                        }
                        ?>
                    </td>
                    <td class="center">
                        <?php
                        if (strtotime($form->display_until) > 0) {
                            echo date('d/m/Y H:i:s', strtotime($form->display_until));
                        } else {
                            echo 'Indefinitely';
                        }
                        ?>
                    </td>
                    <td class="center">
                        <a href="responses.php?id=<?= clean_page($form->id); ?>">
                            <?= FormResponse::where('form_id', $form->id)->count(); ?>
                        </a>
                    </td>
                    <td class="center">
                        <a href="edit.php?id=<?= clean_page($form->id); ?>"
                            class="edit">
                            <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                    <td class="center">
                        <?php
                        if (!in_array($form->id, $donotdelete)) {
                            $params = [
                                'action' => 'delete',
                                'delete_id' => clean_page($form->id),
                            ];
                            ?>
                            <a href="index.php?<?= http_build_query($params)?>"
                                class="alert error"
                                title="Are you sure you want to delete this form?">
                                <i class="fa fa-remove"></i>
                            </a>
                            <?php
                        }
                        ?>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
<?php
} else {
    ?>
    <p>There are currently no forms added</p>
    <?php
}
require_once $path . 'core/admin/templates/adminfooter.html.php';
