<?php
/**
 * Class Panel Builder
 * Generates admin panels
 * @copyright MTC media Ltd.
 * @author Rihards Silins
 * @version 1 24/03/2016
 */

namespace Mtc\Modules\ModuleBuilder\Classes\Builders;

use Illuminate\Database\Capsule\Manager as Capsule;

abstract class PanelBuilder
{
    /**
     * model / object for which the form is being built.
     *
     * @var stdClass
     */
    protected $model;
    /**
     * model / object name which is usually the class name.
     *
     * @var string
     */
    protected $model_name;
    /**
     * path to templates for generating forms
     *
     * @var string
     */
    protected $template_path;
    /**
     * twig to use twig templating language
     *
     * @var object
     */
    protected $twig;
    /**
     * defaults for the PanelBuilder::input() function.
     *
     * @var mixed[][]
     */
    protected $input_default_params = array();
    /**
     * microtime when PanelBuilder::start() was called.
     *
     * @var float
     */
    protected $start_microtime;

    /**
     * PanelBuilder::containerStart()
     * Generate a html opening tag from a key of an array.
     *
     * @param string[] params - key needs to be the tag name for exaple 'div'
     *
     * @return string html - opening tag
     */
    public function containerStart($params)
    {
        $html = '';
        if (!empty($params)) {
            $html .= "<".key($params).' ';
            // add all the extra attributes passed via the params
            foreach ($params[key($params)] as $attribute_name => $value) {
                $html .= $attribute_name.'="'.$value.'" ';
            }
            $html .= ">";
        }
        return $html;
    }

    /**
     * PanelBuilder::containerEnd()
     * Generate a html closing tag from a key of an array.
     *
     * @param string[] params - key needs to be the tag name for exaple 'div'
     *
     * @return string html - ending tag
     */
    public function containerEnd($params)
    {
        $html = '';
        if (!empty($params)) {
            $html .= "</".key($params).">";
        }

        return $html;
    }


    /**
     * ManageListBuilder::filterAdditionalAttributes()
     * From an array of params fetch all the additional attributes and format them in an acceptable format.
     *
     * @param string[] params
     *
     * @return string[] additional_attributes
     */
    public function filterAdditionalAttributes($params)
    {
        // additional attributes
        $additional_attributes = array();
        foreach ($params as $attribute_name => $value) {
            if (empty($value) || is_array($value)) {
                continue;
            }
            $additional_attributes[$attribute_name] = $value;
        }

        return $additional_attributes;
    }

    /**
     * ManageListBuilder::labelFromAttrName()
     * Create a label name form an attribute name.
     *
     * @param string attribute_name
     *
     * @return string label_name
     */
    protected function labelFromAttrName($attr_name)
    {
        $label = str_replace('_', ' ', $attr_name);
        $label = ucwords($label);

        return $label;
    }
}
