Vue.component('patientNotes', {
    props: ['routes','events','initialNotes'],

    data() {
        const initialProvided = Array.isArray(this.initialNotes);
        const initial = initialProvided ? this.initialNotes.slice() : [];
        return {
            notes: initial,
            hasLoaded: initialProvided,
            loading: false,
            errors: {},
            success: false,
            display: 5,
            eventIndex: 0,
        };
    },

    mounted() {
        if (!this.hasLoaded) this.load();
    },

    watch: {
        initialNotes: {
            immediate: true,
            handler(list) {
                if (!Array.isArray(list)) {
                    return;
                }
                this.notes = list.slice();
                this.hasLoaded = true;
                this.loading = false;
            }
        },
        events(stack) {
            for (let i = this.eventIndex; i < stack.length; i++) {
                const event = stack[i];
                if (event.name === 'newNoteAdded') {
                    this.load(true);
                }
            }
            this.eventIndex = stack.length;
        }
    },

    computed: {
        canLoadMore() {
            const list = Array.isArray(this.notes) ? this.notes : [];
            if (!list.length) return false;
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },

        load(force = false) {
            if (this.loading && !force) {
                return;
            }

            this.loading = true;
            const vm = this;

            const applyPayload = (payload) => {
                const list = Array.isArray(payload?.notes) ? payload.notes : [];
                list.sort((a, b) => {
                    // prefer created_at desc; fall back to id desc
                    const ad = Date.parse(a.created_at || a.createdAt || 0);
                    const bd = Date.parse(b.created_at || b.createdAt || 0);
                    if (bd !== ad) return bd - ad;
                    return (b.id || 0) - (a.id || 0);
                });
                vm.notes = list;
                vm.loading = false;
                vm.hasLoaded = true;
                if (typeof vm.cacheBootstrap === 'function') {
                    vm.cacheBootstrap('admin-member-notes-load', { notes: list.slice() });
                }
                if (window.PatientProfileBootstrap) {
                    window.PatientProfileBootstrap.notes = list.slice();
                }
            };

            const cached = (!force && this.consumeBootstrap)
                ? this.consumeBootstrap('admin-member-notes-load')
                : null;
            if (cached) {
                applyPayload(cached);
                return;
            }

            this.$http.post(this.routes['admin-member-notes-load'], {})
                .then((response) => {
                    let payload = response.data;

                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-member-notes-load:', e, payload);
                            payload = {};
                        }
                    }

                    applyPayload(payload);
                })
                .catch((err) => {
                    console.error('Notes load failed:', err);
                    vm.loading = false;
                    vm.notes = [];
                });
        },

        loadMore() {
            this.display += 5;
        },

        addNoteAction(id) {
            this.emitEvent('initAddNote', {
                orderID: id,
            })
        },

        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
