<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('patient_bp_track', function (Blueprint $table) {
            $table->unsignedBigInteger('review_id')->after('file_id')->nullable();
        });
        Schema::table('patient_weight_track', function (Blueprint $table) {
            $table->unsignedBigInteger('review_id')->after('member_id')->nullable();
        });
        Schema::table('assessments', function (Blueprint $table) {
            $table->unsignedBigInteger('review_id')->after('form_id')->nullable();
        });
        Schema::table('member_notes', function (Blueprint $table) {
            $table->unsignedBigInteger('review_id')->after('order_id')->nullable();
        });
        Schema::table('order', function (Blueprint $table) {
            $table->unsignedBigInteger('review_id')->after('parent_id')->nullable();
        });
        if (Schema::hasColumn('reviews', 'order_id')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->dropColumn('order_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('patient_bp_track', function (Blueprint $table) {
            $table->dropColumn('review_id');
        });
        Schema::table('patient_weight_track', function (Blueprint $table) {
            $table->dropColumn('review_id');
        });
        Schema::table('assessments', function (Blueprint $table) {
            $table->dropColumn('review_id');
        });
        Schema::table('member_notes', function (Blueprint $table) {
            $table->dropColumn('review_id');
        });
        Schema::table('order', function (Blueprint $table) {
            $table->dropColumn('review_id');
        });
    }
};
