<?php

namespace Mtc\Modules\MembersMessaging\Classes;

use Mtc\Core\AdminUser;
use Mtc\Modules\Members\Models\Member;
use Mtc\Plugins\MembersMessaging\Classes\Message;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'satisfactory' => null,
]);

$page_meta['title'] = 'Satisfactory';

$append = '';

$messages = (new Message())::query()->where('satisfactory', '>', 0);

if (!empty($_REQUEST['satisfactory'])) {
    $messages = $messages->where('satisfactory', $_REQUEST['satisfactory']);
    $append .= '&satisfactory=' . $_REQUEST['satisfactory'];
}

$totalnumrows = $messages->count();
$rowsPerPage = 25;
$pageNum = empty($_GET['page']) ? 1 : $_GET['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$messages_result = $messages->orderBy('updated_at', 'desc')->skip($offset)->take($rowsPerPage)->get();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Satisfactory</li>
    </ul>

    <h1>Edit template</h1>

    <?php
    require __DIR__ . '/tabnav.php';
    ?>

<form action="" method="GET" class="style">
    <fieldset class="show">
        <h1><a class="show el">Search <i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <label for="satisfactory">Rating</label>
            <select id="satisfactory" name="satisfactory">
                <option value="">All</option>
                <?php
                foreach (Message::$satisfactory_options as $key => $option) {
                    $selected = (int)$_REQUEST['satisfactory'] === $key ? 'selected' : '';
                    ?>
                    <option value="<?= clean_page($key); ?>" <?= $selected; ?>><?= clean_page($option); ?></option>
                    <?php
                }
                ?>
            </select>
        </div>

        <div class="search-button">
            <input type="hidden" name="action" value="search"/>
            <input type="submit" value="Search" class="BUTTON"/>
        </div>
    </fieldset>
</form>

<table class="manage-items">
    <tr>
        <th>Customer</th>
        <th>Admin user</th>
        <th>Date</th>
        <th>Rating date</th>
        <th>Rating</th>
        <th>Comment</th>
    </tr>
    <tbody class="tabular">
    <?php
    foreach ($messages_result as $message) {
        if ($admin_user = (new AdminUser())->find($message->member_id)) {
            if ($member_participant = $message->thread->participants()->where('admin', '0')->first()) {
                $customer = (new Member())->find($member_participant->member_id);
                ?>
                <tr>
                    <td><?= clean_page($customer->addressBilling->firsname . ' ' . $customer->addressBilling->lastname); ?></td>
                    <td><?= clean_page($admin_user->name); ?></td>
                    <td><?= date_convert_db_to_dmy($message->created_at, true); ?></td>
                    <td><?= date_convert_db_to_dmy($message->updated_at, true); ?></td>
                    <td><?= clean_page(Message::$satisfactory_options[$message->satisfactory]); ?></td>
                    <td><?= clean_page($message->comment); ?></td>
                    <td><a href="/plugins/MembersMessaging/admin/view_member_thread.php?url=<?= clean_page($message->thread->url); ?>">View Thread</a></td>
                </tr>
                <?php
            }
        }
    }
    ?>
    </tbody>
</table>
<?php

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.html.php';
