<?php

namespace Mtc\Plugins\NHS\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;


class NHSMemberDoctorSurgery extends Model
{

    protected $table = 'nhs_member_doctor_surgeries';

    protected $fillable = [
        'practice_name',
        'address_1',
        'address_2',
        'city',
        'county',
        'postcode',
        'phone',
        'email',
    ];


    private $rules = [
        'practice_name' => 'required',
        'address_1' => 'required',
        'city' => 'required',
    ];

    private $validation_messages = [];

    public function validate()
    {
        return Validator::make($this->attributes, $this->rules, $this->validation_messages);
    }


    public function nhs_member()
    {
        return $this->belongsTo(NHSMember::class);
    }

}

