//$().ready(function () {

    Vue.component('refund', {

        props: [
            'itemsSizes',
            'order',
            'refundMethods',
            'templates',
        ],

        computed: {
            refund_total: function () {
                var item_refund_amount = 0;
                this.order.items.forEach(function (item) {
                    if (parseFloat(item.to_refund_amount) > 0 ) {
                        item_refund_amount += parseFloat(item.to_refund_amount);
                    }
                });
                return parseFloat(this.order.delivery_refund_amount) + parseFloat(item_refund_amount);
            }
        },

        ready: function() {
            var refund_button = $('#refundOrderButton');
            if (refund_button.hasClass('triggerClick')) {
                refund_button.trigger('click');
            }
        },

        methods: {
            updateItemRefundAmount:function (key) {
                this.order.items[key].to_refund_amount = this.order.items[key].price_paid * this.order.items[key].quantity_to_refund;
            },
            submitReturn: function () {
                var v = this;
                v.refundErrors = null;

                this.$http.post('/plugins/Refunds/admin/', {
                    action: 'do_refund',
                    order: this.order
                }).then(function (response) {
                    if (response.data.status === 'ok') {
                        window.location.reload();
                    } else {
                        v.refundErrors = response.data.messages;
                    }
                });
            }
        },

        data: function() {
            return {
                refundErrors: null,
            };
        },

        template: `
        <section>

            <table width="100%" class="refundTable tabular">
                <thead>
                    <tr class="row_heading">
                        <th>Name</th>
                        <th>Approved</th>
                        <th align="center">Price</th>
                        <th align="center">Price Paid</th>
                        <th align="center">Qty</th>
                        <th align="center">Total</th>
                        <th align="center" class="refundCell">Qty to<br/> Refund</th>
                        <th align="center" class="refundCell">Amount to Refund</th>
                        <th align="center" class="refundCell">Already refunded</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="(item, key) in order.items">
                        <td>
                            <span v-text="item.item_name"></span>

                            <div v-if="itemsSizes">
                                <br/>
                                <span v-if="item.size != 'One Size'" v-text="item.size"></span>
                            </div>
                        </td>
                        <td align="center" width="10%">
                            <i v-bind:class="{'fa fa-check green': item.approved == 1, 'fa fa-ban red': item.approved == 2, }"></i>
                        </td>
                        <td align="center" width="10%">
                            &pound;<span v-text="item.item_price"></span>
                        </td>
                        <td align="center" width="10%">
                            &pound;<span v-text="item.price_paid"></span>
                        </td>
                        <td align="center" width="10%">
                            <span v-text="item.quantity - item.already_refunded_item_qty"></span>
                        </td>
                        <td align="center" width="10%">
                            &pound;<span v-text="(item.quantity * item.price_paid - item.refund_amount)"></span>
                        </td>
                        <td width="10%" class="refundCell">
                            <input type="number"
                                   v-if="!item.is_fully_refunded"
                                   min="0"
                                   :max="item.max_quantity_to_refund"
                                   v-model="item.quantity_to_refund"
                                   @change="updateItemRefundAmount(key)"
                                   @keyUp="updateItemRefundAmount(key)"/>
                        </td>
                        <td width="10%" class="refundCell">
                            <input type="text"
                                   v-model="item.to_refund_amount"/>
                        </td>
                        <td width="10%" align="center" class="refundCell">
                            Qty - <span v-text="item.already_refunded_item_qty"></span> <br/>
                            &pound;<span v-text="item.refunded_amount_per_line"></span>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr class="totals">
                        <th colspan="5">
                            Sub Total
                        </th>
                        <td width="100" align="center">
                            &pound;<span v-text="order.cost_subtotal"></span>
                        </td>
                        <td class="refundCell" colspan="3"></td>
                    </tr>
                    <tr class="totals">
                        <th colspan="5">
                            <span v-if="order.coupon_freedelivery">
                                Delivery
                            </span>
                            <span v-else>
                                <span v-text="order.delivery_name"></span>
                            </span>
                        </th>
                        <td align="center">
                            <span  v-if="order.delivery_cost > 0">
                                &pound;<span v-text="order.delivery_cost"></span>
                            </span>
                            <span v-else>
                                Free
                            </span>
                        </td>
                        <td class="refundCell"></td>
                        <td class="refundCell">
                            <span v-if="order.delivery_cost > 0">
                                <input type="text"
                                       min="0"
                                       :max="order.delivery_refund_amount_max"
                                       name="refund[delivery_cost]"
                                       v-model="order.delivery_refund_amount"/>
                                <p v-if="order.delivery_refund_amount > order.delivery_cost">
                                    <strong style="color:red">
                                        Refunded amount is higher than delivery cost
                                    </strong>
                                </p>
                            </span>
                            <span v-else>
                                &pound;0.00
                            </span>
                        </td>
                        <td align="center" class="refundCell">
                            &pound;<span v-text="order.delivery_amount_refunded"></span>
                        </td>
                    </tr>
                    <tr class="totals" v-if="order.coupon_deduct > 0">
                        <th colspan="5">
                            Discount - Coupon Code - <span v-text="order.coupon_code"></span>
                        </th>
                        <td align="center">
                            &pound;<span v-text="order.coupon_deduct"></span>
                        </td>
                        <td class="refundCell" colspan="3"></td>
                    </tr>

                    <tr v-for="discount in order.discounts" class="totals">
                        <th colspan="5">
                            <span v-text="discount.discount_name"></span>
                        </th>
                        <td align="center">
                            -<span v-text="discount.discount_amount"></span>
                        </td>
                        <td class="refundCell" colspan="3"></td>
                    </tr>
                    <tr class="totals">
                        <th colspan="5">
                            Total Cost
                        </th>
                        <td align="center">
                            &pound;<span v-text="order.cost_total"></span>
                        </td>
                        <td class="refundCell"></td>
                        <td class="refundCell">
                            &pound;<span v-text="refund_total"></span>
                        </td>
                        <td align="center" class="refundCell">
                            &pound;<span v-text="order.already_refunded_amount"></span>
                        </td>
                    </tr>
                    <tr class="refundInfo">
                        <th colspan="6">
                            Refund Reference
                        </th>
                        <td colspan="3">
                           <input type="text" v-model="order.refund_reference"/>
                        </td>
                    </tr>
                    <tr class="refundInfo">
                        <th colspan="6">
                            Refund Note
                        </th>
                        <td colspan="3">
                            <input type="text" v-model="order.refund_note"/>
                        </td>
                    </tr>
                    <tr class="refundInfo">
                        <th colspan="6">
                            Email Template
                        </th>
                        <td colspan="3">
                            <div class="row">
                                <select name="refund_template" v-model="order.refund_template" class="text">
                                    <option value="">Choose email template</option>
                                    <option v-for="template in templates" :value="template.id" v-text="template.title">
                                    </option>
                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr class="refundInfo">
                        <th colspan="6">
                            Refund Method
                        </th>
                        <td colspan="3">
                            <div v-for="method in refundMethods" class="row checkboxRow">
                                <input
                                   type="radio"
                                   v-model="order.refund_method"
                                   :id="'refund_method_' + method.id"
                                   :value="method.id"
                                   name="refund_method_radio"
                                />
                                <label :for="'refund_method_' + method.id" v-text="method.name">
                                </label>
                            </div>
                        </td>
                    </tr>
                    <tr class="refundInfo">
                        <th colspan="6">
                        </th>
                        <td colspan="3">
                            <div class="el error msg" v-if="refundErrors">
                                <ul class="error">
                                    <li v-for="error in refundErrors">
                                        <a href="#0" class="jump" v-text="error"></a>
                                    </li>
                                </ul>
                            </div>
                            <button class="btn" @click.prevent="submitReturn()">
                                Submit Refund
                            </button>
                        </td>
                    </tr>
                </tfoot>
            </table>

        </section>

        `,

    });

//});
