<?php
/**
 * Refunds
 *
 * Shop extension functionality to add in refunds.
 * This requires shop to be present
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\Refunds\Classes;

use Illuminate\Support\Facades\Event;
use Mtc\Shop\Order;

// Install if not yet installed
if (!defined('REFUNDS_ENABLED')) {
//    require_once __DIR__ . '/admin/includes/install.php';
}

if (REFUNDS_ENABLED === true) {
    Refund::confirmComponentExists(Order::class, 'Shop');
    /*
     * Listen for the event where we attempt to load the additional actions of the order.
     * By default this is done from manage order view where all action buttons are located
     */
    Event::listen('shop.admin.manage_order.order_buttons', '\\' . Refund::class . '@adminButton');

    if (COUPON_ENABLED === true) {
        /*
         * Set the ability to refund order via coupon.
         * A coupon is generated in the amount of the order.
         * Requires COUPONS_ENABLED on site.
         */
        Event::listen('refunds.get_refund_methods', function () {
            return [
                'id' => 'coupon',
                'name' => 'Generate Site Voucher',
                'callback' => '\\' . Refund::class . '::createRefundCoupon'
            ];
        });
    }

    /*
     * Set the refund as off site refund.
     * This refund method doesn't do anything as payment will be refunded manually by shop owner
     */
    Event::listen('refunds.get_refund_methods', function () {
        return [
            'id' => 'manual',
            'name' => 'Off Site Refund',
            'callback' => null
        ];
    });

    if (SAGEPAY_SERVER === true) {
        /*
         * Set the ability to refund order via SagePay.
         * Requires SAGEPAY_SERVER on site.
         */
        Event::listen('refunds.get_refund_methods', function () {
            return [
                'id' => 'sagepay',
                'name' => 'SagePay Refund',
                'callback' => '\\' . Refund::class . '::refundSagePay'
            ];
        });
    }
}


