<?php
/**
 * RichCardSchema Loader
 *
 * This code is used to load RichCardSchemas
 *
 * @category Plugins
 * @package  Mtc_RichCardSchemas
 * @author   mtc. Kieran McBurney <kieran.mcburney@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\RichCardSchema\Classes;
use HooksAdapter;

// Add hooks for rich card schemas
HooksAdapter::add_action(
    'contact_page_schema',
    '\Mtc\Plugins\RichCardSchema\Classes\RichCardSchema::addContactPage',
    10, // Priority - 10 is default
    1, // Accepted args from hook
    [ $twig ] // forced args passed to hook
);

HooksAdapter::add_action(
    'item_schema',
    '\Mtc\Plugins\RichCardSchema\Classes\RichCardSchema::addItemSchema',
    10, // Priority - 10 is default
    1, // Accepted args from hook
    [ $twig ] // forced args passed to hook
);
