<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ryft_payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id')->index()->nullable();
            $table->unsignedBigInteger('member_id')->index()->nullable();
            $table->string('remote_id')->index()->nullable();
            $table->string('transaction_id')->index()->nullable();
            $table->decimal('amount');
            $table->string('currency', 5);
            $table->string('status', 20);
            $table->string('method', 20);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ryft_payments');
    }
};
