$(document).ready(function () {
    var sort_happening = false;

    $('#share_buttons_sortable').sortable({
        opacity: 0.6,
        placeholder: 'ui-state-highlight',
        cursor: 'move',
        distance: 5,
        start: function (event, ui) {
            sort_happening = true;
        },
        stop: function (event) {
            sort_happening = false;
        },
        update: function (event, ui) {
            var order = $(this).sortable('serialize') + '&action=order&table=share_buttons&field=order';
            $.ajax({
                type: 'post',
                url: '/core/admin/includes/order.php',
                data: order
            });
        }
    });

    $('form fieldset > h1 a.share_buttons_show').mouseup(function(e){
        if( sort_happening !== true ) {
            e.preventDefault();
            var el = $(this);
            el.parent().siblings().stop(true, true).slideToggle(100, function() {
                var txt = el.find('i.fa-caret-down, i.fa-caret-right');
                if (el.parent().siblings().is(':visible')) {
                    txt.attr('class', 'fa fa-caret-down');
                }
                else {
                    txt.attr('class', 'fa fa-caret-right');
                }
            });
        }
    });
});
