<?php

namespace MtcPharmacy\Bundles\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Item as ShopItem;
use Mtc\Shop\Item\Size as ShopItemSize;


class BundleItem extends Model
{
    protected $table = 'bundle_items';

    protected $fillable = [];


    public function bundle()
    {
        return $this->belongsTo(Bundle::class);
    }


    public function bundle_type_item()
    {
        return $this->belongsTo(BundleTypeItem::class);
    }


    public function shop_item_size()
    {
        return $this->belongsTo(ShopItemSize::class);
    }


    public function getDisplayName()
    {
        $name = $this->shop_item->name;

        if ($this->shop_item_size) {
            $name .= " // {$this->shop_item_size->size}";
        }

        return $name;
    }


}

