# Pharmacy System Starter - Setup Guide

## **Initial Setup (Server Deployment)**

Follow these steps to set up the project on a traditional server:

1. **Create a subdomain** in cPanel and link it to `public_html` (if not already created by the server team).
2. **Create a folder** on the server, e.g., `public_html` (if not already created by the server team).
3. **Clone the repository** into `public_html`:

   **Option A - Using SSH** (recommended if SSH keys are configured):
   ```sh
   git clone git@bitbucket.org:mtcmedia/pharmacy-system-starter.git public_html
   ```

   **Option B - Using HTTPS** (if server doesn't have SSH access to Bitbucket):
   ```sh
   git clone https://bitbucket.org/mtcmedia/pharmacy-system-starter.git public_html
   ```

   **Note**: If you encounter `fatal: destination path 'public_html' already exists and is not an empty directory`, the folder may contain files like `.well-known`. In this case, either:
   - Clone to a temporary location and move files: `git clone [URL] temp && mv temp/* temp/.* public_html/ 2>/dev/null && rmdir temp`
   - Or remove the existing folder contents (backup first if needed): `rm -rf public_html/* && git clone [URL] public_html`

   (Replace `[URL]` with either the SSH or HTTPS URL above)
4. **Create a database**, database user, and attach the user to the database.
5. **Create `.env` file**:
   ```sh
   cp .env.example .env
   ```
6. **Update `.env` configuration**:
   ```dotenv
   APP_ENV=production  # or 'staging' depending on the environment
   APP_DOMAIN=your-subdomain.example.com
   DB_DATABASE=your_database_name
   DB_USERNAME=your_database_user
   DB_PASSWORD=your_database_password
   ```
   **Important**:
   - Set `APP_ENV` to either `staging` or `production` depending on the server environment
   - Update `APP_DOMAIN` to match your subdomain
   - Update all database credentials
7. **Ensure required versions are installed**:
    - **Node.js** version `^16.0`
    - **PHP** version `^8.4`
8. **Run the setup script**:
    ```sh
    sh setup.sh && rm setup.sh
    ```

---

## **Local Setup Using Docker (Optional)**

If you prefer to run the project locally using Docker, follow these steps:

### **Prerequisites**
- Ensure you have **Docker** installed and configured.
- If you haven't installed Docker, follow [this guide](https://docs.docker.com/get-docker/).
- **Windows Users**: Ensure Docker is configured with **WSL**.
- **Mac Users**: Install Docker Desktop for macOS.
- **Linux Users**: Install Docker using your package manager:
  ```sh
  # Ubuntu/Debian
  sudo apt update && sudo apt install docker.io docker-compose -y

  # Fedora
  sudo dnf install docker docker-compose -y
  ```
  After installation, ensure your user has permission to run Docker without `sudo`:
  ```sh
  sudo usermod -aG docker $USER
  ```
  Then restart your session or run:
  ```sh
  newgrp docker
  ```

### **Steps to Run with Docker**
1. **Clone the repository** into your local machine:
   ```sh
   git clone git@bitbucket.org:mtcmedia/pharmacy-system-starter.git ~/pharmacy-starter
   cd ~/pharmacy-starter
   ```
2. **Run the Docker setup script**:
   ```sh
   sh docker-setup.sh
   ```
3. **Once setup is complete**, access the site at:
   ```
   http://localhost
   ```

---

### **📧 Checking Local Emails via MailHog**

This project includes [MailHog](https://github.com/mailhog/MailHog) for testing outgoing emails during development. Emails sent by the application will not reach real inboxes — instead, they are captured and viewable in the MailHog UI.

#### ✅ How to check emails:
1. Ensure the MailHog container is running as part of the Docker setup.
2. Open your browser and visit:

   ```
   http://localhost:8025
   ```

3. You will see a local inbox showing all emails sent by the application during development.

#### 💡 Tips:
- Mail is routed to MailHog when the app is in the `local` environment.
- Ensure your `.env` includes the correct settings:

  ```env
  MAIL_MAILER=smtp
  MAIL_HOST=mailhog
  MAIL_PORT=1025
  MAIL_USERNAME=null
  MAIL_PASSWORD=null
  MAIL_ENCRYPTION=null
  ```

- MailHog does **not** deliver to external addresses, it’s for local testing only.
- If emails don’t appear, double-check the email configuration or restart the Docker containers.

---

## **Useful Docker Commands**
Here are some common commands for managing the Docker environment:

### **Start the Docker environment** (in detached mode):
```sh
docker compose up -d
```
### **Stop the containers**:
```sh
docker compose down
```
### **View running containers**:
```sh
docker ps
```
### **Restart a specific container** (e.g., PHP container):
```sh
docker restart php-container-name
```
### **Access the PHP container's shell**:
```sh
docker exec -it php-container-name bash
```
### **View logs for debugging**:
```sh
docker compose logs -f
```

---

## **Notes**
- The **Docker setup is optional**; use it only if you prefer local containerized development.
- If running on a server, follow the **Initial Setup (Server Deployment)** section above.
```

## 📚 Additional Documentation
- [Internal Git Workflow](./git_workflow_internal.md)
