<?php

use Mtc\Shop\Assessment\Form;
use Mtc\Shop\Assessment\Question;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$display_form = true;

$errors = [];

$form = (new Form())->find($_REQUEST['id']);

$page_meta['title'] = 'Copy Assessment Form';

if ($_REQUEST['action'] === 'save') {
    if (empty($_REQUEST['name'])) {
        $errors[] = 'Please provide form name!';
    }

    if (empty($errors)) {
        $new_id = $form->cloneForm($_REQUEST['name']);

        header('location: manage.form.php?id=' . $new_id);
        exit;
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="manage.forms.php">Manage Assessment Forms</a> /</li>
        <li class="end"><?= clean_page($page_meta['title']) ?></li>
    </ul>

    <h1><?= $page_meta['title']; ?></h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
?>

    <form action="" method="post" class="style">
        <fieldset class="show">
            <h1><a class="show el"><?= $page_meta['title']; ?> <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="form_name">New Form Name</label>
                <input type="text" name="name" id="form_name" value="<?= clean_page($form->name); ?>" class=""/>
            </div>
            <div class="save-button">
                <input type="hidden" name="action" value="save"/>
                <input type="submit" value="Save"/>
            </div>
        </fieldset>
    </form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
