<?php

use Mtc\Shop\Category;
use Mtc\Shop\Item\Image;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

if (!empty($_REQUEST['sub_id'])) {
    $page_meta["title"] = "Sub Category Selection";
} else {
    $page_meta["title"] = "Category Selection";
}

if (empty($append)) {
    $append = '';
}

require_once $path . 'core/admin/templates/adminheader.full.php';


$query = Category::query()
    ->where('sub_id', '=', $_REQUEST['sub_id']);

$totalnumrows = $query->count();

if ($_GET['page']=='') {
    $_GET['page'] = 1;
}
$rowsPerPage = 25;
$pageNum = $_GET['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$categories = $query->orderBy('name')
    ->skip($offset)
    ->take($rowsPerPage)
    ->get();

$append .= '&field='.$_REQUEST['field'];

?>

<ul class="breadcrumbs el">
    <li><a href="manage.categories.mini.php?field=<?= clean_page($_REQUEST['field']) ?>">Categories</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h2>Select a category</h2>

<?php

if ($categories->count() > 0) {
    ?>
    <table class="manage-items tabular">
        <tr class="row_heading">
            <th>ID</th>
            <th>Category</th>
            <th>Image</th>
            <?php
            if (CATEGORIES_SUB==true) {
                ?>
                <th>Sub Categories</th>
                <?php
            }
            ?>
            <th>Use</th>
        </tr>
        <?php
        $row = false;
        foreach ($categories as $category) {
            $data = $category->toArray();
            $row = !$row;
            $onclick = "onclick=\"javascript:opener.document.getElementById('".$_REQUEST['field']."').value='".$data["id"]."';opener.document.getElementById('".$_REQUEST['field']."_name').value='".addslashes($data["name"])."';window.close();\""
            ?>
            <tr class="row<?= $row;?>" style="cursor:pointer;">
                <td <?=$onclick?>><?= $data['id'];?></td>
                <td <?=$onclick?>><?= $data['name'];?></td>
                <td align="center" <?=$onclick?>>

                        <?php if($data['image_name']!='') echo '<img src="' . $path .'/images/categories/thumbs/' . $data['image_name'] . '"/>'; ?>

                </td>
                <?php
                /*
                    Display sub category option
                */
                if (CATEGORIES_SUB==true) {
                    ?>
                    <td align="center"><a href="?sub_id=<?php echo $data['id'];?>&field=<?=$_REQUEST['field']?>">View</a></td>
                    <?php
                }?>
                <td <?=$onclick?>><i class="fa fa-plus-circle"></i></td>
            </tr>
            <?php
        }
        ?>
    </table>
    <?php
} else {
    ?>
    <p>There were no categories found matching your search criteria</p>
    <?php
}

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.full.php';

function get_default_image($item_id)
{
    $image = Image::query()
        ->where('item_id', '=', $item_id)
        ->where('default', '=', 1)
        ->first();

    if (empty($image)) {
        return null;
    }
    return $image->name;
}
