<?php

use Mtc\Shop\CustomFieldSet;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'page' => null,
]);

$page_meta['title'] = 'Manage Custom Field Sets';

if ($_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {
    CustomFieldSet::query()
        ->where('id', '=', $_REQUEST['delete_id'])
        ->delete();
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>

        <li class="end"><?= $page_meta['title'] ?></li>
    </ul>
    <h1><?= $page_meta['title'] ?></h1>

<?php
include 'tabnav.sets.php';
?>

<?php
if (!empty($errors)) {
    showerrors($errors);
}
$query = CustomFieldSet::query();

$totalnumrows = $query->count();

if ($_REQUEST['page'] == '') {
    $_REQUEST['page'] = 1;
}
$rowsPerPage = 25;
$pageNum = $_REQUEST['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;
$customFields = $query->orderBy('id')
    ->skip($offset)
    ->limit($rowsPerPage)
    ->get();

if ($customFields->count() > 0) {
    ?>

    <?php
    if ((empty($errors) && $_REQUEST['action'] == 'update') || $_REQUEST['message'] == 'update' ) {
        echo showmsg("Properties updated", "success", $path);
    } elseif ($_REQUEST['message'] == 'added') {
        echo showmsg("Properties added", "success", $path);
    }
    ?>
    <?php
    if (empty($errors) && $_REQUEST['action'] == 'delete') {
        echo showmsg("Properties removed", "success", $path);
    }
    ?>

    <form action="<?= $_SERVER['PHP_SELF']; ?>" method="post">
        <table class="manage-items">
            <tr>
                <th class="fieldname">Name</th>
                <th class="fieldname">Default</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular ui-sortable">
            <?php
            foreach ($customFields as $customField) {
                $data = $customField->toArray();
                ?>
                <tr id="rorder-<?= $data['id'] ?>">
                    <td><?= clean_page($data['name']) ?></td>
                    <td><?php

                        if($data['default']==1)
                        {
                            echo "Yes";
                        }

                        ?></td>
                    <td class="center"><a href="edit.customfields.set.php?id=<?= $data['id']; ?>" class="edit picto"><i class="fa fa-pencil"></i></a></td>
                    <td class="center"><a href="manage.customfields.sets.php?action=delete&delete_id=<?php echo $data['id']; ?>" class="alert error" title="Are you sure you want to delete this custom field?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
            }
            ?>
            </tbody>
        </table>
    </form>
    <?php
} else {
    ?>
    <p>No Custom Field Sets have been created</p>
    <?php
}

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.html.php';
