/**
 * JS functions for Multibuy Discounts
 *
 * @author Alan Reid <alan@mtcmedia.co.uk>, Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
 */
$(document).ready(function () {
    type_change();
    var type_element = $("#type"),
        clear_button = $("#clear_button"),
        browse_button = $("#browse_button");

    //check for input in discount type dropdown
    $(type_element).click(function () {
        type_change();
    });

    //check for browse button onclick
    $(browse_button).click(function () {
        item_selector_window()
    });

    //check for clear button onclick
    $(clear_button).click(function () {
        clear_data()
    });
}); // end of .ready

//function to change elements according to type change (for discount type selector)
function type_change() {
    var type = $("#type").val(),
        value1 = $("#value1"),
        value2 = $("#value2"),
        row_value1 = $("#row_value1"),
        row_value2 = $("#row_value2");

    if (type == 'nforn') {
        value1.html("N For");
        value2.html("N");
        row_value1.show();
        row_value2.show();
    }
    if (type == 'nforpricen') {
        value1.html("N For");
        value2.html("&pound;");
        row_value1.show();
        row_value2.show();
    }
    if (type == 'amountoff') {
        value1.html("&pound; off");
        value2.html("");
        row_value1.show();
        row_value2.hide();
    }
    if (type == 'percentoff') {
        value1.html("off");
        value2.html("");
        row_value1.show();
        row_value2.css("display", "none");
    }
    if (type == 'freeukdelivery') {
        value1.html("");
        value2.html("");
        row_value1.css.hide();
        row_value2.css.hide();
    }
    if (type == 'freewithorder') {
        value1.html("Item");
        value2.html("");
        row_value1.show();
        row_value2.hide();
    }
}

//function to open item selector window (for restricted items)
function item_selector_window() {
    window.open('/shop/admin/products/manage.products.mini.php?field=item&sex=',
        'productselector',
        'status=yes,scrollbars=yes,' +
        'resizable=yes,' +
        'width=500,' +
        'height=600');
}

//function to clear item data from field (for restricted items)
function clear_data() {
    $("#item").val("");
    $("#item_name").val("");
}
