<?php

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

if (!$order = (new \Mtc\Shop\Order())->find($_REQUEST['order_id'])) {
    header('Location: /shop/admin/orders/manage.orders.php');
    exit;
}

$is_nhs_order = $order->hasNHSItems();

if (empty($_REQUEST['id'])) {
    $order_item = new \Mtc\Shop\Order\Item();
    $order_item->order_id = $order->id;
    if ($order->hasNHSItems()) {
        $reminder = new \Mtc\Plugins\NHS\Classes\Reminder();
    }
} else {
    $order_item = (new \Mtc\Shop\Order\Item())->find($_REQUEST['id']);
    if ($order_item === null || $order_item->order_id != $_REQUEST['order_id']) {
        header('Location: /shop/admin/orders/manage.orders.php');
        exit;
    }
    if ($_REQUEST['action'] === 'delete_order_item') {
        \Mtc\Plugins\NHS\Classes\Reminder::query()->where('order_item_id', $_REQUEST['id'])->delete();
        $order_item->archive();
        $order_item->delete();
        \Mtc\Shop\Order::updateTotals($order->id);
        header('Location: /shop/admin/orders/manage.order.php?' . http_build_query(['id' => $order_item->order_id]));
        exit;
    }

}

$is_private_prescription = false;
if (($order_item->PLU == 'private_prescription') || (isset($_POST['PLU']) && $_POST['PLU'] == 'private_prescription')) {
    $is_private_prescription = true;
}

$errors = [];
if ($_REQUEST['action'] === 'save_order_item') {
    $post = $_POST;
    if (!$is_nhs_order && !$is_private_prescription) {
        $post['item_name'] = $post['item_id_name'];
    }
    $order_item->fill($post);
    $mandatory_fields = [
        'item_name' => 'Item name',
        'quantity' => 'Quantity',
        'item_price' => 'Item Price',
        'item_price_exvat' => 'Item Price Ex VAT',
        'price_paid' => 'Price Paid',
        'price_paid_exvat' => 'Price Paid Ex VAT',
    ];
    // Require size only if item has sizes
    if (!empty($post['item_id']) &&
        \Mtc\Shop\Item\Size::query()->where('item_id', $post['item_id'])->count() > 0)
    {
        $mandatory_fields['sizeid'] = 'Variation';
    }

    if ($is_nhs_order) {
        $mandatory_fields['size'] = 'Prescription Quantity';
    } elseif (!$is_private_prescription) {
        $mandatory_fields['item_id'] = 'Item';
        if (!empty($post['sizeid'])) {
            $order_item->size = \Mtc\Shop\Item\Size::query()->find($post['sizeid'])->size;
        } else {
            $order_item->size = 'One Size';
        }
    }

    foreach($mandatory_fields as $key => $label) {
        if ($post[$key] == '') {
            $errors[$key] = "The {$label} field is required.";
        }
    }

    if (empty($errors)) {
        $order_item->nhs_prescription = $is_nhs_order;

        if (!empty($_REQUEST['id'])) {
            // If editing, save Archive values
            (new \Mtc\Shop\Order\Item())->find($_REQUEST['id'])->archive();
        } else {
            // New items by default approved
            $order_item->approved = '1';
        }
        $order_item->save();

        // Because individual order item has changed, update all order
        \Mtc\Shop\Order::updateTotals($order->id);
        header('Location: /shop/admin/orders/manage.order.php?' . http_build_query(['id' => $order_item->order_id]));
        exit;
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="manage.orders.php">Manage Orders</a> /</li>
        <li><a href="manage.order.php?id=<?=$order_item->order_id?>">Order #<?=$order_item->order_id?></a> /</li>
        <li class="end"><?= empty($_REQUEST['id']) ? 'Add' : 'Edit'; ?> Line Item</li>
    </ul>

    <h1><?= empty($_REQUEST['id']) ? 'Add' : 'Edit'; ?>  Line Item</h1>

<?php
require __DIR__ . '/tabnav.php';

if (!empty($errors)) {
    showerrors($errors);
}
if (!empty($warnings)) {
    showerrors($warnings, 'alert');
}
?>

<form action="" method="POST" class="style" id="editOrderItemForm">
    <fieldset class="show">
        <h1>Order Item</h1>
        <?php
        if ($is_nhs_order || $is_private_prescription) {
            ?>
            <div class="row">
                <label for="item_name">Item name</label>
                <input type="text"
                       name="item_name"
                       id="item_name"
                       value="<?= $order_item->item_name; ?>"
                />
            </div>
            <?php
            if ($is_nhs_order) {
                ?>
                <div class="row">
                    <label for="size">Size</label>
                    <input type="text"
                           name="size"
                           id="size"
                           value="<?= $order_item->size; ?>"
                    />
                </div>
                <?php
            }
        } else {
            ?>
            <div class="row">
                <label for="item_id_name">Product</label>
                <input type="hidden" name="item_id" id="item_id" value="<?= $order_item->item_id; ?>" />
                <input type="text" name="item_id_name" id="item_id_name" value="<?= $order_item->item_name; ?>" class="INPUT1"/>
                <a onclick="window.open('/shop/admin/products/manage.products.mini.php?field=item_id', 'productselector', 'status=yes,scrollbars=yes,resizable=yes,width=500,height=600');" class="btn">Browse</a>
            </div>
            <div class="row hideme" id="variationRow">
                <label for="sizeid">Variation</label>
                <select name="sizeid" id="sizeid"></select>
            </div>
            <?php
        }
        ?>
        <div class="row">
            <label for="item_price">Price</label>
            <input type="text"
                   name="item_price"
                   id="item_price"
                   value="<?= clean_page($order_item->item_price); ?>"
                   class="short"
            />
        </div>
        <div class="row">
            <label for="item_price_exvat">Price Ex VAT</label>
            <input type="text"
                   name="item_price_exvat"
                   id="item_price_exvat"
                   value="<?= clean_page($order_item->item_price_exvat); ?>"
                   class="short"
            />
        </div>
        <div class="row">
            <label for="quantity">Quantity</label>
            <input type="text"
                   name="quantity"
                   id="quantity"
                   value="<?= empty($_REQUEST['id']) ? '1' : clean_page($order_item->quantity); ?>"
                   class="short"
            />
        </div>
        <div class="row">
            <label for="PLU">PLU</label>
            <input type="text"
                   name="PLU"
                   id="PLU"
                   value="<?= clean_page($order_item->PLU); ?>"
                   class="short"
            />
        </div>
        <div class="row">
            <label for="price_paid">Price Paid</label>
            <input type="text"
                   name="price_paid"
                   id="price_paid"
                   value="<?= clean_page($order_item->price_paid); ?>"
                   class="short"
            />
        </div>
        <div class="row">
            <label for="price_paid_exvat">Price Paid Ex VAT</label>
            <input type="text"
                   name="price_paid_exvat"
                   id="price_paid_exvat"
                   value="<?= clean_page($order_item->price_paid_exvat); ?>"
                   class="short"
            />
        </div>
        <input type="hidden" name="vat_deductable" id="vat_deductable" value="<?= $order_item->vat_deductable; ?>" />
        <input type="hidden" name="order_item_id" id="order_item_id" value="<?= $_REQUEST['id']; ?>" />
        <input type="hidden" name="action" value="save_order_item" />
        <div class="row">
            <input type="submit" value="Save" />
        </div>
    </fieldset>
</form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
