<?php

use Illuminate\Support\Facades\Event;
use Mtc\Shop\Item\Image;


header("connection: close");

$path = '../../../';
$admin = true;
require_once $path . 'core/includes/header.inc.php';
$page_meta['title'] = 'Manage Images';
$errors = [];

$item = new Item();
$item->Get_Item(intval($_REQUEST['id']));

if (!is_numeric($item->id)) {
    die("Not an item");
}

$_SESSION['upload_item_id'] = clean_page($_REQUEST['id']);
$_SESSION['item_name'] = clean_page($item->name);

if ($_REQUEST['action'] === 'delete' && is_numeric($_REQUEST['delete_id'])) {
    $image = Image::query()
        ->find($_REQUEST['delete_id']);

    if (empty($image)) {
        exit;
    }

    $data = $image->toArray();

    $file_name = clean_page($data['name']);
    $default  = clean_page($data['default']);

    foreach ($image_folders['product_folders'] as $resize) {
        @unlink(SITE_PATH . '/' . $resize['path'] . '/' . $file_name);
    }
    $image->delete();

    if ($default) {
        Image::query()
            ->where('item_id', $item->id)
            ->limit(1)
            ->update([
                'default' => true,
            ]);

    }
    header("Location:images.php?id=" . clean_page($item->id));
    exit();
}

if (filter_input(INPUT_POST, 'action') === 'update_alt') {
    collect($_POST['alt'])
        ->each(function ($alt_value, $img_id) {
            Image::query()
                ->where('id', $img_id)
                ->update([
                    'alt' => $alt_value
                ]);
        });

    $_SESSION['message'] = 'Alt values updated';
    header("Location:images.php?id=" . clean_page($item->id));
    exit();
}


//set default image
if ($_REQUEST['action'] === 'setdefault' && is_numeric($_REQUEST['default_id'])) {
    Image::query()
        ->where('item_id', $item->id)
        ->update([
            'default' => false,
        ]);
    Image::query()
        ->where('id', $_REQUEST['default_id'])
        ->update([
            'default' => true,
        ]);

    header("Location:images.php?id=" . clean_page($item->id));
    exit();

}

//set hover
if ($_REQUEST['action'] === 'sethover' && is_numeric($_REQUEST['image_id'])) {
    Image::query()
        ->where('item_id', $item->id)
        ->update([
            'hover' => false,
        ]);
    Image::query()
        ->where('id', $_REQUEST['image_id'])
        ->update([
            'hover' => true,
        ]);

    header("Location:images.php?id=" . clean_page($item->id));
    exit();
}

//set zoom
if ($_REQUEST['action'] === 'setzoom' && is_numeric($_REQUEST['image_id'])) {
    $image = Image::query()
        ->find($_REQUEST['image_id']);

    $image->zoom = !$image->zoom;
    $image->save();

    header("Location:images.php?id=" . clean_page($item->id));
    exit();

}

if ($_REQUEST['action'] === 'setsmall' && is_numeric($_REQUEST['image_id'])) {
    Image::query()
        ->where('item_id', $item->id)
        ->update([
            'small' => false,
        ]);
    Image::query()
        ->where('id', $_REQUEST['image_id'])
        ->update([
            'small' => true,
        ]);

    header("Location:images.php?id=" . clean_page($item->id));
    exit();
}


require_once $path . 'core/admin/templates/adminheader.html.php';

?>



<?php Event::dispatch('AdminBeforeBreadcrumbs', $item->eloquent() ?? null); ?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/shop/admin/products/manage.products.php">Manage Products</a> /</li>
    <li><a href="item.php?id=<?= clean_page($_REQUEST['id']) ?>"><?= clean_page($item->name) ?></a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Images</h1>

<?php
require_once 'tabnav.php';

if (!empty($_SESSION['message'])) {
    echo showmsg($_SESSION['message'], 'success', $path);
    unset($_SESSION['message']);
}

if (!empty($errors) && empty($_REQUEST['changesex'])) {
    showerrors($errors);
}
$colspan = 3;
?>

    <form action="<?= \Util::add_query_arg([]) ?>" method="post">
        <table class="manage-items">
            <tr>

                <?php
                if (IMAGES_ORDER === true) {
                    $colspan++;
                ?>

                    <th class="centre">Order</th>

                <?php
                }
                ?>

                <th>Image</th>
                <th>Image Alt value</th>

                <?php
                if (IMAGES_ZOOM === true) {
                    $colspan++;
                ?>

                    <th class="center">Zoom</th>

                <?php
                }
                ?>

                <th class="center">Default</th>

                <?php
                if (ITEM_PREVIEW_HOVER_IMAGE === true && true == false) {
                    $colspan++;
                    ?>

                    <th class="center">Hover</th>

                <?php
                }
                ?>

                <?php
                    if (true == false) {
                ?>
                    <th class="center">Small</th>
                <?php
                    }
                ?>

                <th class="center">Delete</th>
            </tr>

            <?php
            if (IMAGES_ORDER === true){
            ?>

                <tbody class="tabular ui-sortable">

            <?php
            } else {
            ?>

                <tbody class="tabular">

            <?php
            }


            $images = Image::query()
                ->where('item_id', $item->id)
                ->orderBy('order')
                ->orderBy('id')
                ->get();
            if ($images->count() > 0) {
                foreach ($images as $image) {
                    $data = $image->toArray();
                    $citem = new Item();
                    $citem->Get_Item(clean_page($data['item_id']));
            ?>

                    <tr id="rorder-<?= clean_page($data['id']) ?>">

                        <?php
                        if (IMAGES_ORDER === true) {
                        ?>

                            <td class="center order"><i class="fa fa-arrows"></i></td>

                        <?php
                        }
                        ?>

                            <td>
                                <img src="<?= SITE_URL . '/' . $image_folders['product_folders']['thumbs']['path'] . '/' . clean_page($data['name']) ?>" />
                            </td>
                            <td>
                                <input type="text"
                                       name="alt[<?= (int)$data['id'] ?>]"
                                       value="<?= clean_page($data['alt'])  ?>"/>
                            </td>

                        <?php
                        if (IMAGES_ZOOM === true) {
                        ?>

                            <td class="center">

                                <?php
                                if ($data['zoom'] == true) {
                                ?>

                                    <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=setzoom&image_id=<?= clean_page($data['id']) ?>"><i
                                            class="fa fa-check-square"></i></a>

                                <?php
                                } else {
                                ?>

                                    <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=setzoom&image_id=<?= clean_page($data['id']) ?>"><i
                                            class="fa fa-square-o"></i></a>

                                <?php
                                }
                                ?>

                            </td>

                        <?php
                        }
                        ?>

                        <td class="center">

                            <?php
                            if ($data['default'] == true) {
                            ?>

                                <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=setdefault&default_id=<?= clean_page($data['id']) ?>">
                                    <i class="fa fa-check-square"></i>
                                </a>

                            <?php
                            } else {
                            ?>

                                <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=setdefault&default_id=<?= clean_page($data['id']) ?>">
                                    <i class="fa fa-square-o"></i>
                                </a>

                            <?php
                            }
                            ?>

                        </td>

                        <?php
                        if (true == false) {
                        ?>

                            <td class="center">

                                <?php
                                if ($data['hover'] == true) {
                                ?>

                                    <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=sethover&image_id=<?= clean_page($data['id']) ?>">
                                        <i class="fa fa-check-square"></i>
                                    </a>

                                <?php
                                } else {
                                ?>

                                    <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=sethover&image_id=<?= clean_page($data['id']) ?>">
                                        <i class="fa fa-square-o"></i>
                                    </a>

                                <?php
                                }
                                ?>

                            </td>

                        <?php
                        }
                        ?>

                        <?php
                            if (true == false) {
                        ?>
                            <td class="center">
                                <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=setsmall&image_id=<?= clean_page($data['id']) ?>">
                                    <i class="fa <?= $data['small'] ? 'fa-check-square' : 'fa-square-o' ?>"></i>
                                </a>
    
                            </td>
                        <?php
                            }
                        ?>

                        <td class="center">
                            <a href="images.php?id=<?= clean_page($_REQUEST['id']) ?>&action=delete&delete_id=<?= clean_page($data['id']) ?>"
                                title="Are you sure you want to delete this image?" class="alert picto error"
                            >
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </td>
                    </tr>

                <?php
                }
                ?>

                <input type="hidden" id="orderbytable" value="items_images"/>
                <input type="hidden" id="orderbyfield" value="order"/>

            <?php
            } else {
            ?>

                <tr>
                    <td colspan="<?= clean_page($colspan) ?>">There are currently no images uploaded for this item.</td>
                </tr>

            <?php
            }
            ?>

            </tbody>
        </table>
        <div class="row">
            <button type="submit"
                    name="action"
                    class="btn "
                    value="update_alt">
                Update Alt Values
            </button>
        </div>
    </form>

<div class="clearfix clear"></div>

<?php
if ($images->count() < IMAGES_MAX) {
    $image_spaces_left = IMAGES_MAX - count($item->images);
    ?>

    <div id="dZUpload" class="dropzone">
        <div class="dz-default dz-message">Click here or drag images to upload. You can add up
            to <?= clean_page($image_spaces_left) ?> more images.
        </div>
        <input type="hidden" name="item_id" id="item_id" value="<?= clean_page($_REQUEST['id']) ?>"/>
        <input type="hidden" name="max_images" id="max_images" value="<?= clean_page($image_spaces_left) ?>"/>
    </div>

<?php
}
?>

<?php

require_once $path .'core/admin/templates/adminfooter.html.php';
