<?php

use Mtc\Shop\Warning;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'id' => null,
]);


$display_form = true;

$errors = [];

$warning = (new Warning())->findOrNew($_REQUEST['id']);

$addedit = $_REQUEST['id'] ? 'Update' : 'Add';

$page_meta['title'] = $addedit . ' Warning';

if ($_REQUEST['action'] === 'save') {
    $warning->fill($_REQUEST);
    $warning->save();
    header('location: manage.warnings.php');
    exit;
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="manage.warnings.php">Manage Warnings</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Warning</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) {
    showerrors($errors);
}
    ?>

    <form action="" method="post" class="style">
        <fieldset class="show">
            <h1><a class="show el">Warning <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="warning_type">Type</label>

                <select name="warning_type" id="warning_type">
                    <?php
                    foreach (Warning::$warning_types as $warning_type => $type_name) {
                        $selected = $warning_type === $warning->warning_type ? 'selected' : '';
                        echo "<option value='{$warning_type}' {$selected}>{$type_name}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="row">
                <label for="warning_content">Warning Message</label>
                <input type="text" name="content" id="warning_content" value="<?=clean_page($warning->content); ?>" class=""/>
            </div>
       </fieldset>
       <fieldset>
        <div class="save-button">
            <input type="hidden" name="action" value="save"/>
            <input type="submit" value="Save"/>
        </div>
       </fieldset>
    </form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
