<?php

if (defined('BREADCRUMBS') && BREADCRUMBS === true) {

    $breadcrumbs = [];

    $breadcrumbs[] = [
        'id' => 0,
        'url' => '/',
        'name' => 'Home',
    ];

    $breadcrumbs[] = [
        'id' => 1,
        'url' => '/browse',
        'name' => 'Shop',
    ];

    if (sizeof($filter->selections['brands']) > 0) {
        $tmp_filter = new ProductFilter();

        $brand_id = $filter->selections['brands'][0]; // Get first brand selected
        $brand_data = brand_data($brand_id);

        $breadcrumbs[] = [
            'id' => 'brand_' . $brand_id,
            'url' => $tmp_filter->generateURL(array('brand_add' => $brand_id)),
            'name' => $brand_data['name'],
        ];
    }

    if (sizeof($filter->selections['brands']) > 0 && sizeof($filter->selections['categories_toplevel']) > 0) {
        $tmp_filter = new ProductFilter();

        $brand_id = $filter->selections['brands'][0]; //Get first brand selected
        $brand_data = brand_data($brand_id);

        $cat_id = $filter->selections['categories_toplevel'][0];
        $cat_data = category_data($cat_id);

        $breadcrumbs[] = [
            'id' => 'brand_' . $filter->selections['brands'][0],
            'url' => $tmp_filter->generateURL(array('brand_add' => $brand_id, 'category_add' => $cat_id)),
            'name' => clean_page($cat_data['name']),
        ];

    } elseif (sizeof($filter->selections['categories_toplevel']) > 0) {
        $tmp_filter = new ProductFilter();

        $cat_id = $filter->selections['categories_toplevel'][0];
        $cat_data = category_data($cat_id);

        $breadcrumbs[] = [
            'id' => 'brand_' . $cat_id,
            'url' => $tmp_filter->generateURL(array('category_add' => $cat_id)),
            'name' => clean_page($cat_data['name']),
        ];

    }

    if (sizeof($filter->selections['brands']) > 0 && sizeof($filter->selections['categories']) > 0) {
        $tmp_filter = new ProductFilter();

        if (sizeof($filter->selections['categories_toplevel']) > 0) {
            //  echo "adding top level";
            $tmp_filter->selections['categories_toplevel'] = $filter->selections['categories_toplevel'];
            $tmp_filter->selections_all[] = array('type' => 'category', 'value' => $filter->selections['categories_toplevel'][0]);
        }

        $brand_id = $filter->selections['brands'][0]; //Get first brand selected
        $brand_data = brand_data($brand_id);

        $cat_id = $filter->selections['categories'][0];
        $cat_data = category_data($cat_id);

        $breadcrumbs[] = [
            'id' => 'brand_' . $cat_id,
            'url' => $tmp_filter->generateURL(array('brand_add' => $brand_id, 'category_add' => $cat_id)),
            'name' => clean_page($cat_data['name']),
        ];

    } elseif (sizeof($filter->selections['categories']) > 0) {

        $tmp_filter = new ProductFilter();

        if (sizeof($filter->selections['categories_toplevel']) > 0) {
            $tmp_filter->selections['categories_toplevel'] = $filter->selections['categories_toplevel'];
            $tmp_filter->selections_all[] = array('type' => 'category', 'value' => $filter->selections['categories_toplevel'][0]);
        }

        $current_category_id = end($filter->selections['categories']);
        $cat_data = category_data($current_category_id);

        $breadcrumbs = array_merge($breadcrumbs, CategoryHelper::generateBreadcrumbs($current_category_id));

    }

    if (defined('BREADCRUMBS_LINK_LAST_CRUMB') && BREADCRUMBS_LINK_LAST_CRUMB === false) {
        end($breadcrumbs);
        $key = key($breadcrumbs);
        reset($breadcrumbs);

        $breadcrumbs[$key]['url'] = null;
    }

    if(!empty($breadcrumbs)) {
        $breadcrumbs[0]['breadcrumbs_only'] = true;
    }

    $breadcrumbs['breadcrumbs'] = $breadcrumbs;

    echo $twig->render('navigation/breadcrumbs.twig', $breadcrumbs);

}
