<?php

use Mtc\Shop\DeliveryZone;
use Illuminate\Support\Facades\Cache;

$basket_countries = $countries = Cache::remember('delivery_countries', 3600, function () {
    return DeliveryZone::query()
        ->where('disable', 0)
        ->orderBy('country_name')
        ->get()
        ->mapWithKeys(function ($item) {
            return [$item->country_code => $item->country_name];
        });
});
