<?php
/*
 * Extends twig with a function that prints out numbers using the current currency
 */

use Mtc\Shop\Brand;

$twig = app('twig');

/**
 * Load the shop categories for the filter.
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 *
 * @return array|bool Returns array if the filter is inactive, or false.
 */
$twig->addFunction(new \Twig\TwigFunction('shopCategoryTree', function () {
    return PRODUCT_FILTER === false ? CategoryHelper::getCategoryTree() : false;
}));

/**
 * Load the brands for the filter.
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 *
 * @return array|bool Returns array if filter is inactive and brands enabled.
 */
$twig->addFunction(new \Twig\TwigFunction('shopBrandTree', function () {
    if (
        PRODUCT_FILTER === false &&
        defined('BRANDS_ENABLED') &&
        BRANDS_ENABLED === true
    ) {
        return Brand::getAllBrands();
    }

    return false;
}));


/**
 * | small_parentheses
 *
 * @param string $text text to process
 * @return string processed text
 */
$twig->addFilter(new \Twig\TwigFilter('small_parentheses', function ($text) {
    return str_replace('(', '<small>(', str_replace(')', ')</small>', $text));
}, [
    'is_safe' => ['html']
]));


/**
 * | small_parentheses
 *
 * @param string $text text to process
 * @return string processed text
 */
$twig->addFilter(new \Twig\TwigFilter('not_one_size', function ($text) {
    return strtolower($text) !== 'one size' ? $text  : '';
}, [
    'is_safe' => ['html']
]));


$twig->addFunction(new \Twig\TwigFunction('get_category_image', function ($category_id, $size) {
    $category = \Mtc\Shop\Category::query()->find($category_id);
    if ($category && !empty($category->image)) {
        return "<img src='" . THEME_PATH . "/images/loader.svg' data-lazy-menu-img-src='/uploads/images/categories/thumbs/{$category->image}' alt='{$category->name}' class='lazyCatImage'/>";
    }
}, [
    'is_safe' => ['html']
]));
