<?php

namespace Mtc\Shop\Basket;

use App\Casts\OptionalEncrypted;
use Mtc\Core\Address as CoreAddress;

/**
 * Generic Address Eloquent Model.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 17.10.2016.
 */
class Address extends CoreAddress
{
    // Use Belongs to Basket Trait
    use BelongsToBasket;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'basket_address';

    protected $fillable = [
        'basket_id',
        'type',
        'gender',
        'title',
        'firstname',
        'middle_name',
        'lastname',
        'address1',
        'address2',
        'city',
        'state',
        'country',
        'postcode',
        'notes',
    ];

    protected $casts = [
        'firstname' => OptionalEncrypted::class,
        'middle_name' => OptionalEncrypted::class,
        'lastname' => OptionalEncrypted::class,
        'address1' => OptionalEncrypted::class,
        'address2' => OptionalEncrypted::class,
        'city' => OptionalEncrypted::class,
        'postcode' => OptionalEncrypted::class,
    ];

}