<?php
/**
 * Order Discount Object Eloquent model.
 * @version 31/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Discount Object Eloquent model.
 * Implements functionality for managing Shop Order Discounts
 *
 * @version 31/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Discount extends Model
{
    // Use trait that defines relationship to order
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_discounts';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'order_id',
        'discount_amount',
        'discount_type',
        'discount_id',
        'discount_name',
        'payment_type',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

}