<?php
/**
 * Order Shipment Object Eloquent model.
 * @version 10/07/17
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Shipment Object Eloquent model.
 * Implements functionality for managing Shop Order Shipments
 *
 * @version 10/07/17
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Shipment extends Model
{
    // Use trait that defines relationship to order
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_shipment';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'order_id',
        'order_status_id',
        'tracking_no',
        'service',
        'date',
        'carrier',
        'label',
        'label_format',
        'shipment_data',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

}