## Sonarqube setup
This document outlines the steps to set up and migrate Sonarqube for code quality analysis. Note this only for local development (docker) purposes. It is not intended for production use or staging server use.

### Installation of the Sonar Scanner
Download and setup the Sonar Scanner from the official SonarQube website. (https://docs.sonarsource.com/sonarqube-server/10.8/analyzing-source-code/scanners/sonarscanner#windows)


### Check Sonar Scanner is working
To verify that the Sonar Scanner is correctly installed, open a terminal or command prompt and run the following command:
```bash
sonar-scanner --version
```

### Scanning the Project
Make sure the docker container is running. If not, start it with:
```bash
docker-compose up -d
```
Navigate to the sonarqube web interface at `http://localhost:9000` and log in with the default credentials (admin/admin). Change the password when prompted.


1. Create a new project in SonarQube:
2. Select create project
3. select local project
4. select follows the instance's default and create project
5. Select locally as the project is local
6. generate the token for the project
7. select other and copy the command
8. In your terminal, navigate to directory of the project to be scanned and run the copied command.
9. Navigate back to the SonarQube web interface to see the analysis results.
