# Data Model: Component Registry

## Core Entities

### Component
Represents a discovered Twig component file with metadata for display and rendering.

**Fields:**
- `name` (string): Display name derived from filename (e.g., "Newsletter Form")
- `filename` (string): Original file name (e.g., "newsletter_form.twig")
- `path` (string): Relative path from includes directory (e.g., "pages/newsletter/newsletter_form.twig")
- `absolute_path` (string): Full file system path for reading
- `category` (string): Category based on directory structure (e.g., "pages/newsletter")
- `description` (string): Auto-generated description from filename and path analysis
- `file_size` (integer): File size in bytes
- `modified_at` (timestamp): Last modification time for cache invalidation
- `is_renderable` (boolean): Whether component can be safely rendered
- `error_message` (string, nullable): Error details if component fails to render

**Relationships:**
- Has many sample data entries (ComponentSampleData)
- Belongs to category grouping

### ComponentSampleData
Sample/dummy data required to render a component for preview.

**Fields:**
- `component_path` (string): Reference to parent component
- `data_key` (string): Variable name expected by template (e.g., "user", "product")
- `sample_value` (mixed): JSON-encoded sample data
- `data_type` (string): Type hint (string, array, object, etc.)
- `is_required` (boolean): Whether this data is required for rendering

### ComponentCategory
Logical grouping of components based on directory structure.

**Fields:**
- `name` (string): Category name (e.g., "Pages", "Forms", "Popups")
- `slug` (string): URL-safe identifier (e.g., "pages", "forms", "popups")
- `path_prefix` (string): Directory path pattern (e.g., "pages/", "popups/")
- `component_count` (integer): Number of components in category
- `description` (string): Auto-generated category description

## Data Flow

### Component Discovery Process
1. Scan `sites/default/templates/includes/` directory recursively
2. Filter for `.twig` files only
3. Extract metadata (name, path, category) for each file
4. Generate description from filename/path analysis
5. Test renderability with empty/sample data
6. Cache results with file modification time for invalidation

### Sample Data Generation
1. Parse Twig template for variable references ({{ variable }}, {% for item in items %})
2. Generate appropriate sample data based on variable names and context
3. Store common patterns (user, product, items, etc.) with default sample values
4. Allow override of sample data through configuration files

### Category Organization
1. Extract directory structure from component paths
2. Group components by first-level directory (pages/, forms/, etc.)
3. Generate category names from directory names
4. Count components per category for display

## Validation Rules

### Component Validation
- `name`: Required, max 255 characters
- `filename`: Required, must end with `.twig`
- `path`: Required, must be relative path within includes directory
- `absolute_path`: Required, must be valid file path that exists
- `category`: Required, max 100 characters
- `description`: Required, max 500 characters

### Sample Data Validation
- `component_path`: Required, must reference valid component
- `data_key`: Required, valid Twig variable name pattern
- `sample_value`: Must be valid JSON if stored as JSON
- `data_type`: Must be one of: string, integer, float, boolean, array, object

## State Transitions

### Component Lifecycle
1. **Discovered**: File found during directory scan
2. **Analyzed**: Metadata extracted and description generated
3. **Tested**: Renderability checked with sample data
4. **Available**: Ready for display in registry (successful render)
5. **Error**: Failed to render, error message stored

### Cache Lifecycle
1. **Fresh**: Cache entry created with file modification time
2. **Stale**: File modified after cache creation
3. **Expired**: TTL exceeded (5 minutes)
4. **Invalidated**: Manual cache clear or system restart

## Performance Considerations

- File system scanning limited to 200 files maximum (specification limit)
- Caching at component level with 5-minute TTL
- Lazy loading of component previews
- Category-based pagination for large component sets
- Sample data pre-generated and cached to avoid repeated template parsing