# Research: Component Registry Implementation

## Technical Context Analysis
Based on the existing pharmacy system architecture, all technical dependencies are clear:

## Existing System Analysis

### Vue.js Component Integration
**Decision**: Use Vue.js 2 component for the main registry listing page
**Rationale**: System already uses Vue.js 2 with existing component structure in `sites/default/js/components/`
**Implementation Pattern**: Follow existing components like `address_form.vue`, `multi_currency_price.vue`

### Twig Template System
**Decision**: Use Twig templates for component detail pages with new isolated layout
**Rationale**: System uses Twig extensively, existing layout at `sites/default/templates/layouts/main.twig`
**Implementation Pattern**: Create new layout without header/footer, similar to main.twig structure

### File System Scanning Approach
**Decision**: PHP-based directory scanning for component discovery
**Rationale**: Laravel 11 provides robust file system utilities, matches existing architecture
**Implementation Pattern**: Use Laravel's File facade for recursive directory scanning

### Vite Build System Integration
**Decision**: Preserve existing Vite compilation (single JS/CSS files) and include full files
**Rationale**: User requirement to maintain current build process while displaying any integration issues
**Implementation Pattern**: No changes to `vite.config.js`, standard Vue component integration

### Component Description Generation
**Decision**: Parse filename and directory path to generate descriptions
**Rationale**: Clarified requirement from specification - automated analysis via path structure
**Implementation Pattern**: Convert snake_case/kebab-case to readable descriptions, use directory for categorization

## Architecture Decisions

### Routing Strategy
**Decision**: Public frontend routes for both main registry and component detail pages
**Rationale**: Vite build system compiles assets from sites/default/ only, admin areas don't have access to compiled Vue.js components and full CSS/JS assets needed for component previews
**Alternatives Considered**: Admin/CMS integration - rejected as admin areas can't access Vite-compiled assets required for Vue.js components

### Data Storage Strategy
**Decision**: No database storage - real-time file system scanning with caching
**Rationale**: Components change during development, cache invalidation easier than database sync
**Alternatives Considered**: Database caching - rejected due to sync complexity

### Error Handling Strategy
**Decision**: Display technical error details for debugging
**Rationale**: Clarified requirement for developer-focused error messages
**Implementation Pattern**: Try-catch blocks with full error details displayed to user

### Performance Strategy
**Decision**: File system caching with 5-minute TTL, lazy loading for component previews
**Rationale**: Meet 5-second load time requirement while handling 50-200 components
**Implementation Pattern**: Laravel cache facade with file-based caching

## Integration Points

### Existing Frontend Structure
- Register Vue.js component in main `sites/default/js/app.js` bundle
- Use public web routes (not admin routes) for registry and previews
- Access full Vite-compiled assets (app.css, app.js) for complete functionality

### Existing Template System
- Leverage existing Twig environment configuration
- Use existing CSS/JS asset loading patterns from main.twig layout
- Follow existing layout inheritance patterns for isolated preview layout

## No Outstanding Questions
All technical decisions resolved based on existing system architecture and specification clarifications.