<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class ComponentRegistryApiTest extends TestCase
{
    /**
     * Test GET /api/components endpoint returns component list
     */
    public function test_get_components_api_returns_component_list()
    {
        $response = $this->get('/api/components');

        $response->assertStatus(200)
                 ->assertJsonStructure([
                     'data' => [
                         '*' => [
                             'name',
                             'filename',
                             'path',
                             'category',
                             'description',
                             'is_renderable',
                             'file_size',
                             'modified_at'
                         ]
                     ],
                     'meta' => [
                         'total',
                         'per_page',
                         'current_page',
                         'last_page'
                     ],
                     'categories' => [
                         '*' => [
                             'name',
                             'slug',
                             'component_count'
                         ]
                     ]
                 ]);
    }

    /**
     * Test GET /api/components with category filter
     */
    public function test_get_components_api_with_category_filter()
    {
        $response = $this->get('/api/components?category=pages');

        $response->assertStatus(200)
                 ->assertJsonStructure([
                     'data' => [
                         '*' => [
                             'name',
                             'category'
                         ]
                     ]
                 ]);
    }

    /**
     * Test GET /api/components with search parameter
     */
    public function test_get_components_api_with_search()
    {
        $response = $this->get('/api/components?search=newsletter');

        $response->assertStatus(200);
    }

    /**
     * Test GET /api/components handles errors gracefully
     */
    public function test_get_components_api_handles_errors()
    {
        // This test will be implemented to handle file system errors
        $this->assertTrue(true); // Placeholder until implementation
    }
}