<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class ComponentRenderingTest extends TestCase
{
    /**
     * Test component rendering with sample data
     */
    public function test_component_rendering_with_sample_data()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/components/' . $componentPath . '/preview');

        $response->assertStatus(200);
        $content = $response->getContent();

        // Verify component is rendered with sample data
        $this->assertStringContains('component-output', $content);
    }

    /**
     * Test error handling for broken components
     */
    public function test_error_handling_for_broken_components()
    {
        // This will test rendering of components with errors
        // Implementation depends on having actual broken components or mocking
        $this->assertTrue(true); // Placeholder until implementation
    }

    /**
     * Test renderability detection
     */
    public function test_renderability_detection()
    {
        $response = $this->get('/api/components');

        $response->assertStatus(200);
        $data = $response->json();

        // If components exist, verify renderability is detected
        if (count($data['data']) > 0) {
            foreach ($data['data'] as $component) {
                $this->assertArrayHasKey('is_renderable', $component);
                $this->assertIsBool($component['is_renderable']);

                // If not renderable, should have error message
                if (!$component['is_renderable']) {
                    $this->assertArrayHasKey('error_message', $component);
                }
            }
        }
    }

    /**
     * Test Twig environment configuration
     */
    public function test_twig_environment_configuration()
    {
        // Test that Twig can render basic components
        $response = $this->get('/api/components');

        $response->assertStatus(200);

        // If we get a successful response, Twig environment is working
        $this->assertTrue(true);
    }

    /**
     * Test sample data generation for different component types
     */
    public function test_sample_data_generation()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/api/components/' . $componentPath);

        if ($response->status() === 200) {
            $data = $response->json();

            $this->assertArrayHasKey('sample_data', $data);
            $this->assertIsArray($data['sample_data']) || is_object($data['sample_data']);
        }
    }
}