<?php

namespace Tests\Feature;

use App\MemberInfo;
use Mtc\Modules\Members\Models\Member;


class SiteOfOriginTest extends \PHPUnit\Framework\TestCase
{

    public static function dataTestMemberSiteOfOrigin()
    {
        return [
            [ 1 ],
            [ 2 ],
        ];
    }


    /**
     * @dataProvider dataTestMemberSiteOfOrigin
     */
    public function testMemberSiteOfOrigin(int $site_id)
    {
        $test_member = new Member();
        $test_member->save();

        $expected_member_info_id = MemberInfo::registerSiteOfOrigin(
            $test_member,
            $site_id
        );

        $detected_number_info_records = MemberInfo::query()
            ->where('member_id', $test_member->id)
            ->where('multisite__site_id', $site_id)
            ->count()
        ;

        $this->assertSame($detected_number_info_records, 1);

        $expected_member_info_id = MemberInfo::registerSiteOfOrigin(
            $test_member,
            $site_id
        );

        $detected_number_info_records = MemberInfo::query()
            ->where('member_id', $test_member->id)
            ->where('multisite__site_id', $site_id)
            ->count()
        ;

        $this->assertSame($detected_number_info_records, 1);

        $test_member->delete();
    }

}
