<?php
/**
 * Google Analytics information
 * User agent set to what was defined in SEO admin, unless DEV_MODE is on, in
 * which case a defined user agent will be overwritten by the GA_TEST_USERAGENT
 */
$ga_useragent = SeoSettings::getSettingValue('GA_USERAGENT');
if ($ga_useragent && DEV_MODE) {
    $ga_useragent = GA_TEST_USERAGENT;
}
define('GOOGLE_ANALYTICS_USERAGENT', $ga_useragent);

/**
 * PPC tracking
 *
 * allows tracking of orders on https://projects.mtcmedia.co.uk/staff/cpc.php
 */
define('PPC_TRACKING', (!DEV_MODE) ? SeoSettings::getSettingValue('PPC_TRACKING') : 0);

/**
 * Hotjar tracking
 */

define('HOTJAR_TRACKING_CODE', SeoSettings::getSettingValue('HOTJAR_TRACKING_CODE'));

if (! defined('GTM_ID')) {
    define('GTM_ID', SeoSettings::getSettingValue('GTM_ID'));
}
