<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_delete_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_delete_clean_page_cache`
            AFTER DELETE ON `page_list`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_insert_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_insert_clean_page_cache`
            AFTER INSERT ON `page_list`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_update_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_update_clean_page_cache`
            AFTER UPDATE ON `page_list`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_delete_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_delete_clean_page_cache`
            AFTER DELETE ON `page_list_item`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_insert_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_insert_clean_page_cache`
            AFTER INSERT ON `page_list_item`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_update_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_update_clean_page_cache`
            AFTER UPDATE ON `page_list_item`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_data_delete_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_data_delete_clean_page_cache`
            AFTER DELETE ON `page_list_item_data`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_data_insert_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_data_insert_clean_page_cache`
            AFTER INSERT ON `page_list_item_data`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_page_list_item_data_update_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_page_list_item_data_update_clean_page_cache`
            AFTER UPDATE ON `page_list_item_data`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_pages_delete_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_pages_delete_clean_page_cache`
            AFTER DELETE ON `pages`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
                DELETE FROM `tree_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_pages_insert_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_pages_insert_clean_page_cache`
            AFTER INSERT ON `pages`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
                DELETE FROM `tree_cache`;
            END');

        DB::unprepared('DROP TRIGGER IF EXISTS `after_pages_update_clean_page_cache`');
        DB::unprepared('CREATE TRIGGER `after_pages_update_clean_page_cache`
            AFTER UPDATE ON `pages`
            FOR EACH ROW
            BEGIN
                DELETE FROM `page_cache`;
                DELETE FROM `tree_cache`;
            END');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('
            DROP TRIGGER `after_page_list_item_delete_clean_page_cache`;
            DROP TRIGGER `after_page_list_item_data_update_clean_page_cache`;
            DROP TRIGGER `after_page_list_item_data_insert_clean_page_cache`;
            DROP TRIGGER `after_page_list_update_clean_page_cache`;
            DROP TRIGGER `after_page_list_item_update_clean_page_cache`;
            DROP TRIGGER `after_page_list_item_insert_clean_page_cache`;
            DROP TRIGGER `after_pages_update_clean_page_cache`;
            DROP TRIGGER `after_pages_insert_clean_page_cache`;
            DROP TRIGGER `after_pages_delete_clean_page_cache`;
            DROP TRIGGER `after_page_list_item_data_delete_clean_page_cache`;
            DROP TRIGGER `after_page_list_insert_clean_page_cache`;
            DROP TRIGGER `after_page_list_delete_clean_page_cache`;
        ');
    }
};
