<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountriesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        echo 'Seeding countries...' . PHP_EOL;

        DB::table('countries')->delete();
        
        DB::table('countries')->insert(array (
            0 => 
            array (
                'id' => '1',
                'status' => '1',
                'order' => '1',
                'code' => 'AD',
                'name' => 'Andorra',
                'currency_code' => 'EUR',
                'north' => '42.65604389629997',
                'south' => '42.42849259876837',
                'east' => '1.7865427778319827',
                'west' => '1.4071867141112762',
                'capital_name' => 'Andorra la Vella',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'ca',
                'iso_code' => 'AND',
                'dial_code' => '376',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'AD[1-9][0-9]{2}',
            ),
            1 => 
            array (
                'id' => '2',
                'status' => '1',
                'order' => '1',
                'code' => 'AE',
                'name' => 'United Arab Emirates',
                'currency_code' => 'AED',
                'north' => '26.08415985107422',
                'south' => '22.633329391479492',
                'east' => '56.38166046142578',
                'west' => '51.58332824707031',
                'capital_name' => 'Abu Dhabi',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-AE,fa,en,hi,ur',
                'iso_code' => 'ARE',
                'dial_code' => '971',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            2 => 
            array (
                'id' => '3',
                'status' => '1',
                'order' => '1',
                'code' => 'AF',
                'name' => 'Afghanistan',
                'currency_code' => 'AFN',
                'north' => '38.483418',
                'south' => '29.377472',
                'east' => '74.879448',
                'west' => '60.478443',
                'capital_name' => 'Kabul',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'fa-AF,ps,uz-AF,tk',
                'iso_code' => 'AFG',
                'dial_code' => '93',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            3 => 
            array (
                'id' => '4',
                'status' => '1',
                'order' => '1',
                'code' => 'AG',
                'name' => 'Antigua and Barbuda',
                'currency_code' => 'XCD',
                'north' => '17.729387',
                'south' => '16.996979',
                'east' => '-61.672421',
                'west' => '-61.906425',
                'capital_name' => 'St. John\'s',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-AG',
                'iso_code' => 'ATG',
                'dial_code' => '1268',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            4 => 
            array (
                'id' => '5',
                'status' => '1',
                'order' => '1',
                'code' => 'AI',
                'name' => 'Anguilla',
                'currency_code' => 'XCD',
                'north' => '18.283424',
                'south' => '18.166815',
                'east' => '-62.971359',
                'west' => '-63.172901',
                'capital_name' => 'The Valley',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-AI',
                'iso_code' => 'AIA',
                'dial_code' => '1264',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'AI-2640',
            ),
            5 => 
            array (
                'id' => '6',
                'status' => '1',
                'order' => '1',
                'code' => 'AL',
                'name' => 'Albania',
                'currency_code' => 'ALL',
                'north' => '42.665611',
                'south' => '39.648361',
                'east' => '21.068472',
                'west' => '19.293972',
                'capital_name' => 'Tirana',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sq,el',
                'iso_code' => 'ALB',
                'dial_code' => '355',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            6 => 
            array (
                'id' => '7',
                'status' => '1',
                'order' => '1',
                'code' => 'AM',
                'name' => 'Armenia',
                'currency_code' => 'AMD',
                'north' => '41.301834',
                'south' => '38.830528',
                'east' => '46.772435045159995',
                'west' => '43.44978',
                'capital_name' => 'Yerevan',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'hy',
                'iso_code' => 'ARM',
                'dial_code' => '374',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            7 => 
            array (
                'id' => '8',
                'status' => '1',
                'order' => '1',
                'code' => 'AO',
                'name' => 'Angola',
                'currency_code' => 'AOA',
                'north' => '-4.376826',
                'south' => '-18.042076',
                'east' => '24.082119',
                'west' => '11.679219',
                'capital_name' => 'Luanda',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'pt-AO',
                'iso_code' => 'AGO',
                'dial_code' => '244',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            8 => 
            array (
                'id' => '9',
                'status' => '1',
                'order' => '1',
                'code' => 'AQ',
                'name' => 'Antarctica',
                'currency_code' => '',
                'north' => '-60.515533',
                'south' => '-89.9999',
                'east' => '179.9999',
                'west' => '-179.9999',
                'capital_name' => '',
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
                'languages' => '',
                'iso_code' => 'ATA',
                'dial_code' => '0',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            9 => 
            array (
                'id' => '10',
                'status' => '1',
                'order' => '1',
                'code' => 'AR',
                'name' => 'Argentina',
                'currency_code' => 'ARS',
                'north' => '-21.781277',
                'south' => '-55.061314',
                'east' => '-53.591835',
                'west' => '-73.58297',
                'capital_name' => 'Buenos Aires',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-AR,en,it,de,fr,gn',
                'iso_code' => 'ARG',
                'dial_code' => '54',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '([A-Z][1-9][0-9]{3}[A-Z]{3})|([1-9][0-9]{3})',
            ),
            10 => 
            array (
                'id' => '11',
                'status' => '1',
                'order' => '1',
                'code' => 'AS',
                'name' => 'American Samoa',
                'currency_code' => 'USD',
                'north' => '-11.0497',
                'south' => '-14.382478',
                'east' => '-169.416077',
                'west' => '-171.091888',
                'capital_name' => 'Pago Pago',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-AS,sm,to',
                'iso_code' => 'ASM',
                'dial_code' => '1684',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '96799',
            ),
            11 => 
            array (
                'id' => '12',
                'status' => '1',
                'order' => '1',
                'code' => 'AT',
                'name' => 'Austria',
                'currency_code' => 'EUR',
                'north' => '49.0211627691393',
                'south' => '46.3726520216244',
                'east' => '17.1620685652599',
                'west' => '9.53095237240833',
                'capital_name' => 'Vienna',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'de-AT,hr,hu,sl',
                'iso_code' => 'AUT',
                'dial_code' => '43',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            12 => 
            array (
                'id' => '13',
                'status' => '1',
                'order' => '1',
                'code' => 'AU',
                'name' => 'Australia',
                'currency_code' => 'AUD',
                'north' => '-10.062805',
                'south' => '-43.64397',
                'east' => '153.639252',
                'west' => '112.911057',
                'capital_name' => 'Canberra',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-AU',
                'iso_code' => 'AUS',
                'dial_code' => '61',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            13 => 
            array (
                'id' => '14',
                'status' => '1',
                'order' => '1',
                'code' => 'AW',
                'name' => 'Aruba',
                'currency_code' => 'AWG',
                'north' => '12.623718127152925',
                'south' => '12.411707706190716',
                'east' => '-69.86575120104982',
                'west' => '-70.0644737196045',
                'capital_name' => 'Oranjestad',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'nl-AW,es,en',
                'iso_code' => 'ABW',
                'dial_code' => '297',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            14 => 
            array (
                'id' => '15',
                'status' => '1',
                'order' => '1',
                'code' => 'AX',
                'name' => 'Åland',
                'currency_code' => 'EUR',
                'north' => '60.488861',
                'south' => '59.90675',
                'east' => '21.011862',
                'west' => '19.317694',
                'capital_name' => 'Mariehamn',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sv-AX',
                'iso_code' => 'ALA',
                'dial_code' => '358',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '(([1-9][0-9]{4})|(AX-[1-9][0-9]{4}))',
            ),
            15 => 
            array (
                'id' => '16',
                'status' => '1',
                'order' => '1',
                'code' => 'AZ',
                'name' => 'Azerbaijan',
                'currency_code' => 'AZN',
                'north' => '41.90564',
                'south' => '38.38915252685547',
                'east' => '50.370083',
                'west' => '44.774113',
                'capital_name' => 'Baku',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'az,ru,hy',
                'iso_code' => 'AZE',
                'dial_code' => '994',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'AZ[1-9][0-9]{3}',
            ),
            16 => 
            array (
                'id' => '17',
                'status' => '1',
                'order' => '1',
                'code' => 'BA',
                'name' => 'Bosnia and Herzegovina',
                'currency_code' => 'BAM',
                'north' => '45.239193',
                'south' => '42.546112',
                'east' => '19.622223',
                'west' => '15.718945',
                'capital_name' => 'Sarajevo',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'bs,hr-BA,sr-BA',
                'iso_code' => 'BIH',
                'dial_code' => '387',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            17 => 
            array (
                'id' => '18',
                'status' => '1',
                'order' => '1',
                'code' => 'BB',
                'name' => 'Barbados',
                'currency_code' => 'BBD',
                'north' => '13.327257',
                'south' => '13.039844',
                'east' => '-59.420376',
                'west' => '-59.648922',
                'capital_name' => 'Bridgetown',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-BB',
                'iso_code' => 'BRB',
                'dial_code' => '1246',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'BB11000',
            ),
            18 => 
            array (
                'id' => '19',
                'status' => '1',
                'order' => '1',
                'code' => 'BD',
                'name' => 'Bangladesh',
                'currency_code' => 'BDT',
                'north' => '26.631945',
                'south' => '20.743334',
                'east' => '92.673668',
                'west' => '88.028336',
                'capital_name' => 'Dhaka',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'bn-BD,en',
                'iso_code' => 'BGD',
                'dial_code' => '880',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            19 => 
            array (
                'id' => '20',
                'status' => '1',
                'order' => '1',
                'code' => 'BE',
                'name' => 'Belgium',
                'currency_code' => 'EUR',
                'north' => '51.505444',
                'south' => '49.49361',
                'east' => '6.403861',
                'west' => '2.546944',
                'capital_name' => 'Brussels',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'nl-BE,fr-BE,de-BE',
                'iso_code' => 'BEL',
                'dial_code' => '32',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            20 => 
            array (
                'id' => '21',
                'status' => '1',
                'order' => '1',
                'code' => 'BF',
                'name' => 'Burkina Faso',
                'currency_code' => 'XOF',
                'north' => '15.082593',
                'south' => '9.401108',
                'east' => '2.405395',
                'west' => '-5.518916',
                'capital_name' => 'Ouagadougou',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-BF',
                'iso_code' => 'BFA',
                'dial_code' => '226',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            21 => 
            array (
                'id' => '22',
                'status' => '1',
                'order' => '1',
                'code' => 'BG',
                'name' => 'Bulgaria',
                'currency_code' => 'BGN',
                'north' => '44.21764',
                'south' => '41.242084',
                'east' => '28.612167',
                'west' => '22.371166',
                'capital_name' => 'Sofia',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'bg,tr-BG,rom',
                'iso_code' => 'BGR',
                'dial_code' => '359',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            22 => 
            array (
                'id' => '23',
                'status' => '1',
                'order' => '1',
                'code' => 'BH',
                'name' => 'Bahrain',
                'currency_code' => 'BHD',
                'north' => '26.282583',
                'south' => '25.796862',
                'east' => '50.664471',
                'west' => '50.45414',
                'capital_name' => 'Manama',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-BH,en,fa,ur',
                'iso_code' => 'BHR',
                'dial_code' => '973',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '([1-9][0-9]{2})|([1-9][0-9]{3})',
            ),
            23 => 
            array (
                'id' => '24',
                'status' => '1',
                'order' => '1',
                'code' => 'BI',
                'name' => 'Burundi',
                'currency_code' => 'BIF',
                'north' => '-2.310123',
                'south' => '-4.465713',
                'east' => '30.847729',
                'west' => '28.993061',
                'capital_name' => 'Bujumbura',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-BI,rn',
                'iso_code' => 'BDI',
                'dial_code' => '257',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            24 => 
            array (
                'id' => '25',
                'status' => '1',
                'order' => '1',
                'code' => 'BJ',
                'name' => 'Benin',
                'currency_code' => 'XOF',
                'north' => '12.418347',
                'south' => '6.225748',
                'east' => '3.851701',
                'west' => '0.774575',
                'capital_name' => 'Porto-Novo',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-BJ',
                'iso_code' => 'BEN',
                'dial_code' => '229',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            25 => 
            array (
                'id' => '26',
                'status' => '1',
                'order' => '1',
                'code' => 'BL',
                'name' => 'Saint Barthélemy',
                'currency_code' => 'EUR',
                'north' => '17.928808791949283',
                'south' => '17.878183227405575',
                'east' => '-62.788983372985854',
                'west' => '-62.8739118253784',
                'capital_name' => 'Gustavia',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'fr',
                'iso_code' => 'BLM',
                'dial_code' => '590',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '97133',
            ),
            26 => 
            array (
                'id' => '27',
                'status' => '1',
                'order' => '1',
                'code' => 'BM',
                'name' => 'Bermuda',
                'currency_code' => 'BMD',
                'north' => '32.393833',
                'south' => '32.246639',
                'east' => '-64.651993',
                'west' => '-64.89605',
                'capital_name' => 'Hamilton',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-BM,pt',
                'iso_code' => 'BMU',
                'dial_code' => '1441',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '([A-Z]{2} [0-9]{2})|([A-Z]{2} [A-Z]{2})',
            ),
            27 => 
            array (
                'id' => '28',
                'status' => '1',
                'order' => '1',
                'code' => 'BN',
                'name' => 'Brunei',
                'currency_code' => 'BND',
                'north' => '5.047167',
                'south' => '4.003083',
                'east' => '115.359444',
                'west' => '114.071442',
                'capital_name' => 'Bandar Seri Begawan',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ms-BN,en-BN',
                'iso_code' => 'BRN',
                'dial_code' => '673',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[A-Z]{2}[1-9][0-9]{3}',
            ),
            28 => 
            array (
                'id' => '29',
                'status' => '1',
                'order' => '1',
                'code' => 'BO',
                'name' => 'Bolivia',
                'currency_code' => 'BOB',
                'north' => '-9.680567',
                'south' => '-22.896133',
                'east' => '-57.45809600000001',
                'west' => '-69.640762',
                'capital_name' => 'Sucre',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-BO,qu,ay',
                'iso_code' => 'BOL',
                'dial_code' => '591',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            29 => 
            array (
                'id' => '30',
                'status' => '1',
                'order' => '1',
                'code' => 'BQ',
                'name' => 'Bonaire',
                'currency_code' => 'USD',
                'north' => '12.304535',
                'south' => '12.017149',
                'east' => '-68.192307',
                'west' => '-68.416458',
                'capital_name' => '',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'nl,pap,en',
                'iso_code' => 'BES',
                'dial_code' => '599',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            30 => 
            array (
                'id' => '31',
                'status' => '1',
                'order' => '1',
                'code' => 'BR',
                'name' => 'Brazil',
                'currency_code' => 'BRL',
                'north' => '5.264877',
                'south' => '-33.750706',
                'east' => '-32.392998',
                'west' => '-73.985535',
                'capital_name' => 'Brasília',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'pt-BR,es,en,fr',
                'iso_code' => 'BRA',
                'dial_code' => '55',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{4}(?:[-\\s][0-9]{3})?',
            ),
            31 => 
            array (
                'id' => '32',
                'status' => '1',
                'order' => '1',
                'code' => 'BS',
                'name' => 'Bahamas',
                'currency_code' => 'BSD',
                'north' => '26.919243',
                'south' => '22.852743',
                'east' => '-74.423874',
                'west' => '-78.995911',
                'capital_name' => 'Nassau',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-BS',
                'iso_code' => 'BHS',
                'dial_code' => '1242',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            32 => 
            array (
                'id' => '33',
                'status' => '1',
                'order' => '1',
                'code' => 'BT',
                'name' => 'Bhutan',
                'currency_code' => 'BTN',
                'north' => '28.323778',
                'south' => '26.70764',
                'east' => '92.125191',
                'west' => '88.75972',
                'capital_name' => 'Thimphu',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'dz',
                'iso_code' => 'BTN',
                'dial_code' => '975',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            33 => 
            array (
                'id' => '34',
                'status' => '1',
                'order' => '1',
                'code' => 'BV',
                'name' => 'Bouvet Island',
                'currency_code' => 'NOK',
                'north' => '-54.400322',
                'south' => '-54.462383',
                'east' => '3.487976',
                'west' => '3.335499',
                'capital_name' => '',
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
                'languages' => '',
                'iso_code' => 'BVT',
                'dial_code' => '55',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            34 => 
            array (
                'id' => '35',
                'status' => '1',
                'order' => '1',
                'code' => 'BW',
                'name' => 'Botswana',
                'currency_code' => 'BWP',
                'north' => '-17.780813',
                'south' => '-26.907246',
                'east' => '29.360781',
                'west' => '19.999535',
                'capital_name' => 'Gaborone',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-BW,tn-BW',
                'iso_code' => 'BWA',
                'dial_code' => '267',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            35 => 
            array (
                'id' => '36',
                'status' => '1',
                'order' => '1',
                'code' => 'BY',
                'name' => 'Belarus',
                'currency_code' => 'BYR',
                'north' => '56.165806',
                'south' => '51.256416',
                'east' => '32.770805',
                'west' => '23.176889',
                'capital_name' => 'Minsk',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'be,ru',
                'iso_code' => 'BLR',
                'dial_code' => '375',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            36 => 
            array (
                'id' => '37',
                'status' => '1',
                'order' => '1',
                'code' => 'BZ',
                'name' => 'Belize',
                'currency_code' => 'BZD',
                'north' => '18.496557',
                'south' => '15.8893',
                'east' => '-87.776985',
                'west' => '-89.224815',
                'capital_name' => 'Belmopan',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-BZ,es',
                'iso_code' => 'BLZ',
                'dial_code' => '501',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            37 => 
            array (
                'id' => '38',
                'status' => '1',
                'order' => '1',
                'code' => 'CA',
                'name' => 'Canada',
                'currency_code' => 'CAD',
                'north' => '83.110626',
                'south' => '41.67598',
                'east' => '-52.636291',
                'west' => '-141',
                'capital_name' => 'Ottawa',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-CA,fr-CA,iu',
                'iso_code' => 'CAN',
                'dial_code' => '1',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[A-Z][0-9][A-Z][-\\s][0-9][A-Z][0-9]',
            ),
            38 => 
            array (
                'id' => '39',
                'status' => '1',
                'order' => '1',
                'code' => 'CC',
                'name' => 'Cocos [Keeling] Islands',
                'currency_code' => 'AUD',
                'north' => '-12.072459094',
                'south' => '-12.208725839',
                'east' => '96.929489344',
                'west' => '96.816941408',
                'capital_name' => 'West Island',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ms-CC,en',
                'iso_code' => 'CCK',
                'dial_code' => '672',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            39 => 
            array (
                'id' => '40',
                'status' => '1',
                'order' => '1',
                'code' => 'CD',
                'name' => 'Democratic Republic of the Congo',
                'currency_code' => 'CDF',
                'north' => '5.386098',
                'south' => '-13.455675',
                'east' => '31.305912',
                'west' => '12.204144',
                'capital_name' => 'Kinshasa',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-CD,ln,kg',
                'iso_code' => 'COD',
                'dial_code' => '242',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            40 => 
            array (
                'id' => '41',
                'status' => '1',
                'order' => '1',
                'code' => 'CF',
                'name' => 'Central African Republic',
                'currency_code' => 'XAF',
                'north' => '11.007569',
                'south' => '2.220514',
                'east' => '27.463421',
                'west' => '14.420097',
                'capital_name' => 'Bangui',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-CF,sg,ln,kg',
                'iso_code' => 'CAF',
                'dial_code' => '236',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            41 => 
            array (
                'id' => '42',
                'status' => '1',
                'order' => '1',
                'code' => 'CG',
                'name' => 'Republic of the Congo',
                'currency_code' => 'XAF',
                'north' => '3.703082',
                'south' => '-5.027223',
                'east' => '18.649839',
                'west' => '11.205009',
                'capital_name' => 'Brazzaville',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-CG,kg,ln-CG',
                'iso_code' => 'COG',
                'dial_code' => '242',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            42 => 
            array (
                'id' => '43',
                'status' => '1',
                'order' => '1',
                'code' => 'CH',
                'name' => 'Switzerland',
                'currency_code' => 'CHF',
                'north' => '47.805332',
                'south' => '45.825695',
                'east' => '10.491472',
                'west' => '5.957472',
                'capital_name' => 'Berne',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'de-CH,fr-CH,it-CH,rm',
                'iso_code' => 'CHE',
                'dial_code' => '41',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            43 => 
            array (
                'id' => '44',
                'status' => '1',
                'order' => '1',
                'code' => 'CI',
                'name' => 'Ivory Coast',
                'currency_code' => 'XOF',
                'north' => '10.736642',
                'south' => '4.357067',
                'east' => '-2.494897',
                'west' => '-8.599302',
                'capital_name' => 'Yamoussoukro',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-CI',
                'iso_code' => 'CIV',
                'dial_code' => '225',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            44 => 
            array (
                'id' => '45',
                'status' => '1',
                'order' => '1',
                'code' => 'CK',
                'name' => 'Cook Islands',
                'currency_code' => 'NZD',
                'north' => '-10.023114',
                'south' => '-21.944164',
                'east' => '-157.312134',
                'west' => '-161.093658',
                'capital_name' => 'Avarua',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-CK,mi',
                'iso_code' => 'COK',
                'dial_code' => '682',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            45 => 
            array (
                'id' => '46',
                'status' => '1',
                'order' => '1',
                'code' => 'CL',
                'name' => 'Chile',
                'currency_code' => 'CLP',
                'north' => '-17.507553',
                'south' => '-55.9256225109217',
                'east' => '-66.417557',
                'west' => '-80.785851',
                'capital_name' => 'Santiago',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-CL',
                'iso_code' => 'CHL',
                'dial_code' => '56',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{3}(?:[-\\s])?[0-9]{4}',
            ),
            46 => 
            array (
                'id' => '47',
                'status' => '1',
                'order' => '1',
                'code' => 'CM',
                'name' => 'Cameroon',
                'currency_code' => 'XAF',
                'north' => '13.078056',
                'south' => '1.652548',
                'east' => '16.192116',
                'west' => '8.494763',
                'capital_name' => 'Yaoundé',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-CM,fr-CM',
                'iso_code' => 'CMR',
                'dial_code' => '237',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            47 => 
            array (
                'id' => '48',
                'status' => '1',
                'order' => '1',
                'code' => 'CN',
                'name' => 'China',
                'currency_code' => 'CNY',
                'north' => '53.56086',
                'south' => '15.775416',
                'east' => '134.773911',
                'west' => '73.557693',
                'capital_name' => 'Beijing',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'zh-CN,yue,wuu,dta,ug,za',
                'iso_code' => 'CHN',
                'dial_code' => '86',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            48 => 
            array (
                'id' => '49',
                'status' => '1',
                'order' => '1',
                'code' => 'CO',
                'name' => 'Colombia',
                'currency_code' => 'COP',
                'north' => '13.380502',
                'south' => '-4.225869',
                'east' => '-66.869835',
                'west' => '-81.728111',
                'capital_name' => 'Bogotá',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-CO',
                'iso_code' => 'COL',
                'dial_code' => '57',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            49 => 
            array (
                'id' => '50',
                'status' => '1',
                'order' => '1',
                'code' => 'CR',
                'name' => 'Costa Rica',
                'currency_code' => 'CRC',
                'north' => '11.216819',
                'south' => '8.032975',
                'east' => '-82.555992',
                'west' => '-85.950623',
                'capital_name' => 'San José',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-CR,en',
                'iso_code' => 'CRI',
                'dial_code' => '506',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            50 => 
            array (
                'id' => '51',
                'status' => '1',
                'order' => '1',
                'code' => 'CU',
                'name' => 'Cuba',
                'currency_code' => 'CUP',
                'north' => '23.226042',
                'south' => '19.828083',
                'east' => '-74.131775',
                'west' => '-84.957428',
                'capital_name' => 'Havana',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-CU',
                'iso_code' => 'CUB',
                'dial_code' => '53',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            51 => 
            array (
                'id' => '52',
                'status' => '1',
                'order' => '1',
                'code' => 'CV',
                'name' => 'Cape Verde',
                'currency_code' => 'CVE',
                'north' => '17.197178',
                'south' => '14.808022',
                'east' => '-22.669443',
                'west' => '-25.358747',
                'capital_name' => 'Praia',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'pt-CV',
                'iso_code' => 'CPV',
                'dial_code' => '238',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            52 => 
            array (
                'id' => '53',
                'status' => '1',
                'order' => '1',
                'code' => 'CW',
                'name' => 'Curacao',
                'currency_code' => 'ANG',
                'north' => '12.385672',
                'south' => '12.032745',
                'east' => '-68.733948',
                'west' => '-69.157204',
                'capital_name' => 'Willemstad',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'nl,pap',
                'iso_code' => 'CUW',
                'dial_code' => '599',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            53 => 
            array (
                'id' => '54',
                'status' => '1',
                'order' => '1',
                'code' => 'CX',
                'name' => 'Christmas Island',
                'currency_code' => 'AUD',
                'north' => '-10.412356007',
                'south' => '-10.5704829995',
                'east' => '105.712596992',
                'west' => '105.533276992',
                'capital_name' => 'The Settlement',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'en,zh,ms-CC',
                'iso_code' => 'CXR',
                'dial_code' => '61',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            54 => 
            array (
                'id' => '55',
                'status' => '1',
                'order' => '1',
                'code' => 'CY',
                'name' => 'Cyprus',
                'currency_code' => 'EUR',
                'north' => '35.701527',
                'south' => '34.6332846722908',
                'east' => '34.59791599999994',
                'west' => '32.27308300000004',
                'capital_name' => 'Nicosia',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'el-CY,tr-CY,en',
                'iso_code' => 'CYP',
                'dial_code' => '357',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            55 => 
            array (
                'id' => '56',
                'status' => '1',
                'order' => '1',
                'code' => 'CZ',
                'name' => 'Czech Republic',
                'currency_code' => 'CZK',
                'north' => '51.058887',
                'south' => '48.542915',
                'east' => '18.860111',
                'west' => '12.096194',
                'capital_name' => 'Prague',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'cs,sk',
                'iso_code' => 'CZE',
                'dial_code' => '420',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}[\\s][0-9]{2}',
            ),
            56 => 
            array (
                'id' => '57',
                'status' => '1',
                'order' => '1',
                'code' => 'DE',
                'name' => 'Germany',
                'currency_code' => 'EUR',
                'north' => '55.055637',
                'south' => '47.275776',
                'east' => '15.039889',
                'west' => '5.865639',
                'capital_name' => 'Berlin',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'de',
                'iso_code' => 'DEU',
                'dial_code' => '49',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            57 => 
            array (
                'id' => '58',
                'status' => '1',
                'order' => '1',
                'code' => 'DJ',
                'name' => 'Djibouti',
                'currency_code' => 'DJF',
                'north' => '12.706833',
                'south' => '10.909917',
                'east' => '43.416973',
                'west' => '41.773472',
                'capital_name' => 'Djibouti',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-DJ,ar,so-DJ,aa',
                'iso_code' => 'DJI',
                'dial_code' => '253',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            58 => 
            array (
                'id' => '59',
                'status' => '1',
                'order' => '1',
                'code' => 'DK',
                'name' => 'Denmark',
                'currency_code' => 'DKK',
                'north' => '57.748417',
                'south' => '54.562389',
                'east' => '15.158834',
                'west' => '8.075611',
                'capital_name' => 'Copenhagen',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'da-DK,en,fo,de-DK',
                'iso_code' => 'DNK',
                'dial_code' => '45',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            59 => 
            array (
                'id' => '60',
                'status' => '1',
                'order' => '1',
                'code' => 'DM',
                'name' => 'Dominica',
                'currency_code' => 'XCD',
                'north' => '15.631809',
                'south' => '15.20169',
                'east' => '-61.244152',
                'west' => '-61.484108',
                'capital_name' => 'Roseau',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-DM',
                'iso_code' => 'DMA',
                'dial_code' => '1767',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            60 => 
            array (
                'id' => '61',
                'status' => '1',
                'order' => '1',
                'code' => 'DO',
                'name' => 'Dominican Republic',
                'currency_code' => 'DOP',
                'north' => '19.929859',
                'south' => '17.543159',
                'east' => '-68.32',
                'west' => '-72.003487',
                'capital_name' => 'Santo Domingo',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-DO',
                'iso_code' => 'DOM',
                'dial_code' => '1809',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            61 => 
            array (
                'id' => '62',
                'status' => '1',
                'order' => '1',
                'code' => 'DZ',
                'name' => 'Algeria',
                'currency_code' => 'DZD',
                'north' => '37.093723',
                'south' => '18.960028',
                'east' => '11.979548',
                'west' => '-8.673868',
                'capital_name' => 'Algiers',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-DZ',
                'iso_code' => 'DZA',
                'dial_code' => '213',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            62 => 
            array (
                'id' => '63',
                'status' => '1',
                'order' => '1',
                'code' => 'EC',
                'name' => 'Ecuador',
                'currency_code' => 'USD',
                'north' => '1.43902',
                'south' => '-4.998823',
                'east' => '-75.184586',
                'west' => '-81.078598',
                'capital_name' => 'Quito',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-EC',
                'iso_code' => 'ECU',
                'dial_code' => '593',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            63 => 
            array (
                'id' => '64',
                'status' => '1',
                'order' => '1',
                'code' => 'EE',
                'name' => 'Estonia',
                'currency_code' => 'EUR',
                'north' => '59.676224',
                'south' => '57.516193',
                'east' => '28.209972',
                'west' => '21.837584',
                'capital_name' => 'Tallinn',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'et,ru',
                'iso_code' => 'EST',
                'dial_code' => '372',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            64 => 
            array (
                'id' => '65',
                'status' => '1',
                'order' => '1',
                'code' => 'EG',
                'name' => 'Egypt',
                'currency_code' => 'EGP',
                'north' => '31.667334',
                'south' => '21.725389',
                'east' => '36.89833068847656',
                'west' => '24.698111',
                'capital_name' => 'Cairo',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-EG,en,fr',
                'iso_code' => 'EGY',
                'dial_code' => '20',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            65 => 
            array (
                'id' => '66',
                'status' => '1',
                'order' => '1',
                'code' => 'EH',
                'name' => 'Western Sahara',
                'currency_code' => 'MAD',
                'north' => '27.669674',
                'south' => '20.774158',
                'east' => '-8.670276',
                'west' => '-17.103182',
                'capital_name' => 'El Aaiún',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar,mey',
                'iso_code' => 'ESH',
                'dial_code' => '212',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            66 => 
            array (
                'id' => '67',
                'status' => '1',
                'order' => '1',
                'code' => 'ER',
                'name' => 'Eritrea',
                'currency_code' => 'ERN',
                'north' => '18.003084',
                'south' => '12.359555',
                'east' => '43.13464',
                'west' => '36.438778',
                'capital_name' => 'Asmara',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'aa-ER,ar,tig,kun,ti-ER',
                'iso_code' => 'ERI',
                'dial_code' => '291',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            67 => 
            array (
                'id' => '68',
                'status' => '1',
                'order' => '1',
                'code' => 'ES',
                'name' => 'Spain',
                'currency_code' => 'EUR',
                'north' => '43.7913565913767',
                'south' => '36.0001044260548',
                'east' => '4.32778473043961',
                'west' => '-9.30151567231899',
                'capital_name' => 'Madrid',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'es-ES,ca,gl,eu,oc',
                'iso_code' => 'ESP',
                'dial_code' => '34',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            68 => 
            array (
                'id' => '69',
                'status' => '1',
                'order' => '1',
                'code' => 'ET',
                'name' => 'Ethiopia',
                'currency_code' => 'ETB',
                'north' => '14.89375',
                'south' => '3.402422',
                'east' => '47.986179',
                'west' => '32.999939',
                'capital_name' => 'Addis Ababa',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'am,en-ET,om-ET,ti-ET,so-ET,sid',
                'iso_code' => 'ETH',
                'dial_code' => '251',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            69 => 
            array (
                'id' => '70',
                'status' => '1',
                'order' => '1',
                'code' => 'FI',
                'name' => 'Finland',
                'currency_code' => 'EUR',
                'north' => '70.096054',
                'south' => '59.808777',
                'east' => '31.580944',
                'west' => '20.556944',
                'capital_name' => 'Helsinki',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'fi-FI,sv-FI,smn',
                'iso_code' => 'FIN',
                'dial_code' => '358',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            70 => 
            array (
                'id' => '71',
                'status' => '1',
                'order' => '1',
                'code' => 'FJ',
                'name' => 'Fiji',
                'currency_code' => 'FJD',
                'north' => '-12.480111',
                'south' => '-20.67597',
                'east' => '-178.424438',
                'west' => '177.129334',
                'capital_name' => 'Suva',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-FJ,fj',
                'iso_code' => 'FJI',
                'dial_code' => '679',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            71 => 
            array (
                'id' => '72',
                'status' => '1',
                'order' => '1',
                'code' => 'FK',
                'name' => 'Falkland Islands',
                'currency_code' => 'FKP',
                'north' => '-51.24065',
                'south' => '-52.360512',
                'east' => '-57.712486',
                'west' => '-61.345192',
                'capital_name' => 'Stanley',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'en-FK',
                'iso_code' => 'FLK',
                'dial_code' => '500',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'FIQQ 1ZZ',
            ),
            72 => 
            array (
                'id' => '73',
                'status' => '1',
                'order' => '1',
                'code' => 'FM',
                'name' => 'Micronesia',
                'currency_code' => 'USD',
                'north' => '10.08904',
                'south' => '1.02629',
                'east' => '163.03717',
                'west' => '137.33648',
                'capital_name' => 'Palikir',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg',
                'iso_code' => 'FSM',
                'dial_code' => '691',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            73 => 
            array (
                'id' => '74',
                'status' => '1',
                'order' => '1',
                'code' => 'FO',
                'name' => 'Faroe Islands',
                'currency_code' => 'DKK',
                'north' => '62.400749',
                'south' => '61.394943',
                'east' => '-6.399583',
                'west' => '-7.458',
                'capital_name' => 'Tórshavn',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'fo,da-FO',
                'iso_code' => 'FRO',
                'dial_code' => '298',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            74 => 
            array (
                'id' => '75',
                'status' => '1',
                'order' => '1',
                'code' => 'FR',
                'name' => 'France',
                'currency_code' => 'EUR',
                'north' => '51.092804',
                'south' => '41.371582',
                'east' => '9.561556',
                'west' => '-5.142222',
                'capital_name' => 'Paris',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'fr-FR,frp,br,co,ca,eu,oc',
                'iso_code' => 'FRA',
                'dial_code' => '33',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            75 => 
            array (
                'id' => '76',
                'status' => '1',
                'order' => '1',
                'code' => 'GA',
                'name' => 'Gabon',
                'currency_code' => 'XAF',
                'north' => '2.322612',
                'south' => '-3.978806',
                'east' => '14.502347',
                'west' => '8.695471',
                'capital_name' => 'Libreville',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-GA',
                'iso_code' => 'GAB',
                'dial_code' => '241',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            76 => 
            array (
                'id' => '77',
                'status' => '1',
                'order' => '0',
                'code' => 'GB',
                'name' => 'United Kingdom',
                'currency_code' => 'GBP',
                'north' => '59.360249',
                'south' => '49.906193',
                'east' => '1.759',
                'west' => '-8.623555',
                'capital_name' => 'London',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en-GB,cy-GB,gd',
                'iso_code' => 'GBR',
                'dial_code' => '44',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '([A-Z]+)(\\d+[A-Z]?) (\\d)([A-Z]+)',
            ),
            77 => 
            array (
                'id' => '78',
                'status' => '1',
                'order' => '1',
                'code' => 'GD',
                'name' => 'Grenada',
                'currency_code' => 'XCD',
                'north' => '12.318283928171299',
                'south' => '11.986893',
                'east' => '-61.57676970108031',
                'west' => '-61.802344',
                'capital_name' => 'St. George\'s',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-GD',
                'iso_code' => 'GRD',
                'dial_code' => '1473',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            78 => 
            array (
                'id' => '79',
                'status' => '1',
                'order' => '1',
                'code' => 'GE',
                'name' => 'Georgia',
                'currency_code' => 'GEL',
                'north' => '43.586498',
                'south' => '41.053196',
                'east' => '46.725971',
                'west' => '40.010139',
                'capital_name' => 'Tbilisi',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ka,ru,hy,az',
                'iso_code' => 'GEO',
                'dial_code' => '995',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            79 => 
            array (
                'id' => '80',
                'status' => '1',
                'order' => '1',
                'code' => 'GF',
                'name' => 'French Guiana',
                'currency_code' => 'EUR',
                'north' => '5.776496',
                'south' => '2.127094',
                'east' => '-51.613949',
                'west' => '-54.542511',
                'capital_name' => 'Cayenne',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'fr-GF',
                'iso_code' => 'GUF',
                'dial_code' => '594',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '973[0-9]{2}',
            ),
            80 => 
            array (
                'id' => '81',
                'status' => '1',
                'order' => '1',
                'code' => 'GG',
                'name' => 'Guernsey',
                'currency_code' => 'GBP',
                'north' => '49.731727816705416',
                'south' => '49.40764156876899',
                'east' => '-2.1577152112246267',
                'west' => '-2.673194593476069',
                'capital_name' => 'St Peter Port',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en,fr',
                'iso_code' => 'GGY',
                'dial_code' => '44',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '(GY[0-9] [0-9][A-Z]{2})|(GY[0-9]{2} [0-9][A-Z]{2})',
            ),
            81 => 
            array (
                'id' => '82',
                'status' => '1',
                'order' => '1',
                'code' => 'GH',
                'name' => 'Ghana',
                'currency_code' => 'GHS',
                'north' => '11.173301',
                'south' => '4.736723',
                'east' => '1.191781',
                'west' => '-3.25542',
                'capital_name' => 'Accra',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-GH,ak,ee,tw',
                'iso_code' => 'GHA',
                'dial_code' => '233',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            82 => 
            array (
                'id' => '83',
                'status' => '1',
                'order' => '1',
                'code' => 'GI',
                'name' => 'Gibraltar',
                'currency_code' => 'GIP',
                'north' => '36.155439135670726',
                'south' => '36.10903070140248',
                'east' => '-5.338285164001491',
                'west' => '-5.36626149743654',
                'capital_name' => 'Gibraltar',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en-GI,es,it,pt',
                'iso_code' => 'GIB',
                'dial_code' => '350',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'GX11 1AA',
            ),
            83 => 
            array (
                'id' => '84',
                'status' => '1',
                'order' => '1',
                'code' => 'GL',
                'name' => 'Greenland',
                'currency_code' => 'DKK',
                'north' => '83.627357',
                'south' => '59.777401',
                'east' => '-11.312319',
                'west' => '-73.04203',
                'capital_name' => 'Nuuk',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'kl,da-GL,en',
                'iso_code' => 'GRL',
                'dial_code' => '299',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            84 => 
            array (
                'id' => '85',
                'status' => '1',
                'order' => '1',
                'code' => 'GM',
                'name' => 'Gambia',
                'currency_code' => 'GMD',
                'north' => '13.826571',
                'south' => '13.064252',
                'east' => '-13.797793',
                'west' => '-16.825079',
                'capital_name' => 'Banjul',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-GM,mnk,wof,wo,ff',
                'iso_code' => 'GMB',
                'dial_code' => '220',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            85 => 
            array (
                'id' => '86',
                'status' => '1',
                'order' => '1',
                'code' => 'GN',
                'name' => 'Guinea',
                'currency_code' => 'GNF',
                'north' => '12.67622',
                'south' => '7.193553',
                'east' => '-7.641071',
                'west' => '-14.926619',
                'capital_name' => 'Conakry',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-GN',
                'iso_code' => 'GIN',
                'dial_code' => '224',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            86 => 
            array (
                'id' => '87',
                'status' => '1',
                'order' => '1',
                'code' => 'GP',
                'name' => 'Guadeloupe',
                'currency_code' => 'EUR',
                'north' => '16.516848',
                'south' => '15.867565',
                'east' => '-61',
                'west' => '-61.544765',
                'capital_name' => 'Basse-Terre',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'fr-GP',
                'iso_code' => 'GLP',
                'dial_code' => '590',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '971[0-9]{2}',
            ),
            87 => 
            array (
                'id' => '88',
                'status' => '1',
                'order' => '1',
                'code' => 'GQ',
                'name' => 'Equatorial Guinea',
                'currency_code' => 'XAF',
                'north' => '2.346989',
                'south' => '0.92086',
                'east' => '11.335724',
                'west' => '9.346865',
                'capital_name' => 'Malabo',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'es-GQ,fr',
                'iso_code' => 'GNQ',
                'dial_code' => '240',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            88 => 
            array (
                'id' => '89',
                'status' => '1',
                'order' => '1',
                'code' => 'GR',
                'name' => 'Greece',
                'currency_code' => 'EUR',
                'north' => '41.7484999849641',
                'south' => '34.8020663391466',
                'east' => '28.2470831714347',
                'west' => '19.3736035624134',
                'capital_name' => 'Athens',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'el-GR,en,fr',
                'iso_code' => 'GRC',
                'dial_code' => '30',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}[\\s][0-9]{2}',
            ),
            89 => 
            array (
                'id' => '90',
                'status' => '1',
                'order' => '1',
                'code' => 'GS',
                'name' => 'South Georgia and the South Sandwich Islands',
                'currency_code' => 'GBP',
                'north' => '-53.970467',
                'south' => '-59.479259',
                'east' => '-26.229326',
                'west' => '-38.021175',
                'capital_name' => 'Grytviken',
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
                'languages' => 'en',
                'iso_code' => 'SGS',
                'dial_code' => '500',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'SIQQ 1ZZ',
            ),
            90 => 
            array (
                'id' => '91',
                'status' => '1',
                'order' => '1',
                'code' => 'GT',
                'name' => 'Guatemala',
                'currency_code' => 'GTQ',
                'north' => '17.81522',
                'south' => '13.737302',
                'east' => '-88.223198',
                'west' => '-92.23629',
                'capital_name' => 'Guatemala City',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-GT',
                'iso_code' => 'GTM',
                'dial_code' => '502',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            91 => 
            array (
                'id' => '92',
                'status' => '1',
                'order' => '1',
                'code' => 'GU',
                'name' => 'Guam',
                'currency_code' => 'USD',
                'north' => '13.654402',
                'south' => '13.23376',
                'east' => '144.956894',
                'west' => '144.61806',
                'capital_name' => 'Hagåtña',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-GU,ch-GU',
                'iso_code' => 'GUM',
                'dial_code' => '1671',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            92 => 
            array (
                'id' => '93',
                'status' => '1',
                'order' => '1',
                'code' => 'GW',
                'name' => 'Guinea-Bissau',
                'currency_code' => 'XOF',
                'north' => '12.680789',
                'south' => '10.924265',
                'east' => '-13.636522',
                'west' => '-16.717535',
                'capital_name' => 'Bissau',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'pt-GW,pov',
                'iso_code' => 'GNB',
                'dial_code' => '245',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            93 => 
            array (
                'id' => '94',
                'status' => '1',
                'order' => '1',
                'code' => 'GY',
                'name' => 'Guyana',
                'currency_code' => 'GYD',
                'north' => '8.557567',
                'south' => '1.17508',
                'east' => '-56.480251',
                'west' => '-61.384762',
                'capital_name' => 'Georgetown',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'en-GY',
                'iso_code' => 'GUY',
                'dial_code' => '592',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            94 => 
            array (
                'id' => '95',
                'status' => '1',
                'order' => '1',
                'code' => 'HK',
                'name' => 'Hong Kong',
                'currency_code' => 'HKD',
                'north' => '22.559778',
                'south' => '22.15325',
                'east' => '114.434753',
                'west' => '113.837753',
                'capital_name' => 'Hong Kong',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'zh-HK,yue,zh,en',
                'iso_code' => 'HKG',
                'dial_code' => '852',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            95 => 
            array (
                'id' => '96',
                'status' => '1',
                'order' => '1',
                'code' => 'HM',
                'name' => 'Heard Island and McDonald Islands',
                'currency_code' => 'AUD',
                'north' => '-52.909416',
                'south' => '-53.192001',
                'east' => '73.859146',
                'west' => '72.596535',
                'capital_name' => '',
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
                'languages' => '',
                'iso_code' => 'HMD',
                'dial_code' => '0',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            96 => 
            array (
                'id' => '97',
                'status' => '1',
                'order' => '1',
                'code' => 'HN',
                'name' => 'Honduras',
                'currency_code' => 'HNL',
                'north' => '16.510256',
                'south' => '12.982411',
                'east' => '-83.155403',
                'west' => '-89.350792',
                'capital_name' => 'Tegucigalpa',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-HN',
                'iso_code' => 'HND',
                'dial_code' => '504',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'HN[1-9][0-9]{4}',
            ),
            97 => 
            array (
                'id' => '98',
                'status' => '1',
                'order' => '1',
                'code' => 'HR',
                'name' => 'Croatia',
                'currency_code' => 'HRK',
                'north' => '46.53875',
                'south' => '42.43589',
                'east' => '19.427389',
                'west' => '13.493222',
                'capital_name' => 'Zagreb',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'hr-HR,sr',
                'iso_code' => 'HRV',
                'dial_code' => '385',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            98 => 
            array (
                'id' => '99',
                'status' => '1',
                'order' => '1',
                'code' => 'HT',
                'name' => 'Haiti',
                'currency_code' => 'HTG',
                'north' => '20.08782',
                'south' => '18.021032',
                'east' => '-71.613358',
                'west' => '-74.478584',
                'capital_name' => 'Port-au-Prince',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'ht,fr-HT',
                'iso_code' => 'HTI',
                'dial_code' => '509',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            99 => 
            array (
                'id' => '100',
                'status' => '1',
                'order' => '1',
                'code' => 'HU',
                'name' => 'Hungary',
                'currency_code' => 'HUF',
                'north' => '48.585667',
                'south' => '45.74361',
                'east' => '22.906',
                'west' => '16.111889',
                'capital_name' => 'Budapest',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'hu-HU',
                'iso_code' => 'HUN',
                'dial_code' => '36',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            100 => 
            array (
                'id' => '101',
                'status' => '1',
                'order' => '1',
                'code' => 'ID',
                'name' => 'Indonesia',
                'currency_code' => 'IDR',
                'north' => '5.904417',
                'south' => '-10.941861',
                'east' => '141.021805',
                'west' => '95.009331',
                'capital_name' => 'Jakarta',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'id,en,nl,jv',
                'iso_code' => 'IDN',
                'dial_code' => '62',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            101 => 
            array (
                'id' => '102',
                'status' => '1',
                'order' => '1',
                'code' => 'IE',
                'name' => 'Ireland',
                'currency_code' => 'EUR',
                'north' => '55.387917',
                'south' => '51.451584',
                'east' => '-6.002389',
                'west' => '-10.478556',
                'capital_name' => 'Dublin',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en-IE,ga-IE',
                'iso_code' => 'IRL',
                'dial_code' => '353',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '([A-Z0-9]{3}\\s[A-Z0-9]{4})?',
            ),
            102 => 
            array (
                'id' => '103',
                'status' => '1',
                'order' => '1',
                'code' => 'IL',
                'name' => 'Israel',
                'currency_code' => 'ILS',
                'north' => '33.340137',
                'south' => '29.496639',
                'east' => '35.876804',
                'west' => '34.270278754419145',
                'capital_name' => '',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'he,ar-IL,en-IL,',
                'iso_code' => 'ISR',
                'dial_code' => '972',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{6}',
            ),
            103 => 
            array (
                'id' => '104',
                'status' => '1',
                'order' => '1',
                'code' => 'IM',
                'name' => 'Isle of Man',
                'currency_code' => 'GBP',
                'north' => '54.419724',
                'south' => '54.055916',
                'east' => '-4.3115',
                'west' => '-4.798722',
                'capital_name' => 'Douglas',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en,gv',
                'iso_code' => 'IMN',
                'dial_code' => '44',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '(IM[0-9] [0-9][A-Z]{2})|(IM[0-9]{2} [0-9][A-Z]{2})',
            ),
            104 => 
            array (
                'id' => '105',
                'status' => '1',
                'order' => '1',
                'code' => 'IN',
                'name' => 'India',
                'currency_code' => 'INR',
                'north' => '35.504223',
                'south' => '6.747139',
                'east' => '97.403305',
                'west' => '68.186691',
                'capital_name' => 'New Delhi',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc',
                'iso_code' => 'IND',
                'dial_code' => '91',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{3}(?:[-\\s])?[0-9]{3}',
            ),
            105 => 
            array (
                'id' => '106',
                'status' => '1',
                'order' => '1',
                'code' => 'IO',
                'name' => 'British Indian Ocean Territory',
                'currency_code' => 'USD',
                'north' => '-5.268333',
                'south' => '-7.438028',
                'east' => '72.493164',
                'west' => '71.259972',
                'capital_name' => '',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'en-IO',
                'iso_code' => 'IOT',
                'dial_code' => '246',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'BBND 1ZZ',
            ),
            106 => 
            array (
                'id' => '107',
                'status' => '1',
                'order' => '1',
                'code' => 'IQ',
                'name' => 'Iraq',
                'currency_code' => 'IQD',
                'north' => '37.378029',
                'south' => '29.069445',
                'east' => '48.575916',
                'west' => '38.795887',
                'capital_name' => 'Baghdad',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-IQ,ku,hy',
                'iso_code' => 'IRQ',
                'dial_code' => '964',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            107 => 
            array (
                'id' => '108',
                'status' => '1',
                'order' => '1',
                'code' => 'IR',
                'name' => 'Iran',
                'currency_code' => 'IRR',
                'north' => '39.777222',
                'south' => '25.064083',
                'east' => '63.317471',
                'west' => '44.047279',
                'capital_name' => 'Tehran',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'fa-IR,ku',
                'iso_code' => 'IRN',
                'dial_code' => '98',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{9}',
            ),
            108 => 
            array (
                'id' => '109',
                'status' => '1',
                'order' => '1',
                'code' => 'IS',
                'name' => 'Iceland',
                'currency_code' => 'ISK',
                'north' => '66.53463',
                'south' => '63.393253',
                'east' => '-13.495815',
                'west' => '-24.546524',
                'capital_name' => 'Reykjavik',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'is,en,de,da,sv,no',
                'iso_code' => 'ISL',
                'dial_code' => '354',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            109 => 
            array (
                'id' => '110',
                'status' => '1',
                'order' => '1',
                'code' => 'IT',
                'name' => 'Italy',
                'currency_code' => 'EUR',
                'north' => '47.095196',
                'south' => '36.652779',
                'east' => '18.513445',
                'west' => '6.614889',
                'capital_name' => 'Rome',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'it-IT,de-IT,fr-IT,sc,ca,co,sl',
                'iso_code' => 'ITA',
                'dial_code' => '39',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            110 => 
            array (
                'id' => '111',
                'status' => '1',
                'order' => '1',
                'code' => 'JE',
                'name' => 'Jersey',
                'currency_code' => 'GBP',
                'north' => '49.265057',
                'south' => '49.169834',
                'east' => '-2.022083',
                'west' => '-2.260028',
                'capital_name' => 'Saint Helier',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'en,pt',
                'iso_code' => 'JEY',
                'dial_code' => '44',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '(JE[0-9] [0-9][A-Z]{2})|(JE[0-9]{2} [0-9][A-Z]{2})',
            ),
            111 => 
            array (
                'id' => '112',
                'status' => '1',
                'order' => '1',
                'code' => 'JM',
                'name' => 'Jamaica',
                'currency_code' => 'JMD',
                'north' => '18.526976',
                'south' => '17.703554',
                'east' => '-76.180321',
                'west' => '-78.366638',
                'capital_name' => 'Kingston',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-JM',
                'iso_code' => 'JAM',
                'dial_code' => '1876',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]',
            ),
            112 => 
            array (
                'id' => '113',
                'status' => '1',
                'order' => '1',
                'code' => 'JO',
                'name' => 'Jordan',
                'currency_code' => 'JOD',
                'north' => '33.367668',
                'south' => '29.185888',
                'east' => '39.301167',
                'west' => '34.959999',
                'capital_name' => 'Amman',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-JO,en',
                'iso_code' => 'JOR',
                'dial_code' => '962',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            113 => 
            array (
                'id' => '114',
                'status' => '1',
                'order' => '1',
                'code' => 'JP',
                'name' => 'Japan',
                'currency_code' => 'JPY',
                'north' => '45.52314',
                'south' => '24.249472',
                'east' => '145.820892',
                'west' => '122.93853',
                'capital_name' => 'Tokyo',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ja',
                'iso_code' => 'JPN',
                'dial_code' => '81',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}[-\\s][1-9][0-9]{3}',
            ),
            114 => 
            array (
                'id' => '115',
                'status' => '1',
                'order' => '1',
                'code' => 'KE',
                'name' => 'Kenya',
                'currency_code' => 'KES',
                'north' => '5.019938',
                'south' => '-4.678047',
                'east' => '41.899078',
                'west' => '33.908859',
                'capital_name' => 'Nairobi',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-KE,sw-KE',
                'iso_code' => 'KEN',
                'dial_code' => '254',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{4}',
            ),
            115 => 
            array (
                'id' => '116',
                'status' => '1',
                'order' => '1',
                'code' => 'KG',
                'name' => 'Kyrgyzstan',
                'currency_code' => 'KGS',
                'north' => '43.238224',
                'south' => '39.172832',
                'east' => '80.283165',
                'west' => '69.276611',
                'capital_name' => 'Bishkek',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ky,uz,ru',
                'iso_code' => 'KGZ',
                'dial_code' => '996',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            116 => 
            array (
                'id' => '117',
                'status' => '1',
                'order' => '1',
                'code' => 'KH',
                'name' => 'Cambodia',
                'currency_code' => 'KHR',
                'north' => '14.686417',
                'south' => '10.409083',
                'east' => '107.627724',
                'west' => '102.339996',
                'capital_name' => 'Phnom Penh',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'km,fr,en',
                'iso_code' => 'KHM',
                'dial_code' => '855',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            117 => 
            array (
                'id' => '118',
                'status' => '1',
                'order' => '1',
                'code' => 'KI',
                'name' => 'Kiribati',
                'currency_code' => 'AUD',
                'north' => '4.71957',
                'south' => '-11.446881150186856',
                'east' => '-150.215347',
                'west' => '169.556137',
                'capital_name' => 'Tarawa',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-KI,gil',
                'iso_code' => 'KIR',
                'dial_code' => '686',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            118 => 
            array (
                'id' => '119',
                'status' => '1',
                'order' => '1',
                'code' => 'KM',
                'name' => 'Comoros',
                'currency_code' => 'KMF',
                'north' => '-11.362381',
                'south' => '-12.387857',
                'east' => '44.538223',
                'west' => '43.21579',
                'capital_name' => 'Moroni',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar,fr-KM',
                'iso_code' => 'COM',
                'dial_code' => '269',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            119 => 
            array (
                'id' => '120',
                'status' => '1',
                'order' => '1',
                'code' => 'KN',
                'name' => 'Saint Kitts and Nevis',
                'currency_code' => 'XCD',
                'north' => '17.420118',
                'south' => '17.095343',
                'east' => '-62.543266',
                'west' => '-62.86956',
                'capital_name' => 'Basseterre',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-KN',
                'iso_code' => 'KNA',
                'dial_code' => '1869',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            120 => 
            array (
                'id' => '121',
                'status' => '1',
                'order' => '1',
                'code' => 'KP',
                'name' => 'North Korea',
                'currency_code' => 'KPW',
                'north' => '43.006054',
                'south' => '37.673332',
                'east' => '130.674866',
                'west' => '124.315887',
                'capital_name' => 'Pyongyang',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ko-KP',
                'iso_code' => 'PRK',
                'dial_code' => '850',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            121 => 
            array (
                'id' => '122',
                'status' => '1',
                'order' => '1',
                'code' => 'KR',
                'name' => 'South Korea',
                'currency_code' => 'KRW',
                'north' => '38.612446',
                'south' => '33.190945',
                'east' => '129.584671',
                'west' => '125.887108',
                'capital_name' => 'Seoul',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ko-KR,en',
                'iso_code' => 'KOR',
                'dial_code' => '82',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            122 => 
            array (
                'id' => '123',
                'status' => '1',
                'order' => '1',
                'code' => 'KW',
                'name' => 'Kuwait',
                'currency_code' => 'KWD',
                'north' => '30.095945',
                'south' => '28.524611',
                'east' => '48.431473',
                'west' => '46.555557',
                'capital_name' => 'Kuwait City',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-KW,en',
                'iso_code' => 'KWT',
                'dial_code' => '965',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            123 => 
            array (
                'id' => '124',
                'status' => '1',
                'order' => '1',
                'code' => 'KY',
                'name' => 'Cayman Islands',
                'currency_code' => 'KYD',
                'north' => '19.7617',
                'south' => '19.263029',
                'east' => '-79.727272',
                'west' => '-81.432777',
                'capital_name' => 'George Town',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-KY',
                'iso_code' => 'CYM',
                'dial_code' => '1345',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'KY[1-9][-\\s][1-9][0-9]{3}',
            ),
            124 => 
            array (
                'id' => '125',
                'status' => '1',
                'order' => '1',
                'code' => 'KZ',
                'name' => 'Kazakhstan',
                'currency_code' => 'KZT',
                'north' => '55.451195',
                'south' => '40.936333',
                'east' => '87.312668',
                'west' => '46.491859',
                'capital_name' => 'Astana',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'kk,ru',
                'iso_code' => 'KAZ',
                'dial_code' => '7',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            125 => 
            array (
                'id' => '126',
                'status' => '1',
                'order' => '1',
                'code' => 'LA',
                'name' => 'Laos',
                'currency_code' => 'LAK',
                'north' => '22.500389',
                'south' => '13.910027',
                'east' => '107.697029',
                'west' => '100.093056',
                'capital_name' => 'Vientiane',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'lo,fr,en',
                'iso_code' => 'LAO',
                'dial_code' => '856',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            126 => 
            array (
                'id' => '127',
                'status' => '1',
                'order' => '1',
                'code' => 'LB',
                'name' => 'Lebanon',
                'currency_code' => 'LBP',
                'north' => '34.691418',
                'south' => '33.05386',
                'east' => '36.639194',
                'west' => '35.114277',
                'capital_name' => 'Beirut',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-LB,fr-LB,en,hy',
                'iso_code' => 'LBN',
                'dial_code' => '961',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            127 => 
            array (
                'id' => '128',
                'status' => '1',
                'order' => '1',
                'code' => 'LC',
                'name' => 'Saint Lucia',
                'currency_code' => 'XCD',
                'north' => '14.103245',
                'south' => '13.704778',
                'east' => '-60.874203',
                'west' => '-61.07415',
                'capital_name' => 'Castries',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-LC',
                'iso_code' => 'LCA',
                'dial_code' => '1758',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            128 => 
            array (
                'id' => '129',
                'status' => '1',
                'order' => '1',
                'code' => 'LI',
                'name' => 'Liechtenstein',
                'currency_code' => 'CHF',
                'north' => '47.2706251386959',
                'south' => '47.0484284123471',
                'east' => '9.63564281136796',
                'west' => '9.47167359782014',
                'capital_name' => 'Vaduz',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'de-LI',
                'iso_code' => 'LIE',
                'dial_code' => '423',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            129 => 
            array (
                'id' => '130',
                'status' => '1',
                'order' => '1',
                'code' => 'LK',
                'name' => 'Sri Lanka',
                'currency_code' => 'LKR',
                'north' => '9.831361',
                'south' => '5.916833',
                'east' => '81.881279',
                'west' => '79.652916',
                'capital_name' => 'Colombo',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'si,ta,en',
                'iso_code' => 'LKA',
                'dial_code' => '94',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            130 => 
            array (
                'id' => '131',
                'status' => '1',
                'order' => '1',
                'code' => 'LR',
                'name' => 'Liberia',
                'currency_code' => 'LRD',
                'north' => '8.551791',
                'south' => '4.353057',
                'east' => '-7.365113',
                'west' => '-11.492083',
                'capital_name' => 'Monrovia',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-LR',
                'iso_code' => 'LBR',
                'dial_code' => '231',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            131 => 
            array (
                'id' => '132',
                'status' => '1',
                'order' => '1',
                'code' => 'LS',
                'name' => 'Lesotho',
                'currency_code' => 'LSL',
                'north' => '-28.572058',
                'south' => '-30.668964',
                'east' => '29.465761',
                'west' => '27.029068',
                'capital_name' => 'Maseru',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-LS,st,zu,xh',
                'iso_code' => 'LSO',
                'dial_code' => '266',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            132 => 
            array (
                'id' => '133',
                'status' => '1',
                'order' => '1',
                'code' => 'LT',
                'name' => 'Lithuania',
                'currency_code' => 'EUR',
                'north' => '56.446918',
                'south' => '53.901306',
                'east' => '26.871944',
                'west' => '20.941528',
                'capital_name' => 'Vilnius',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'lt,ru,pl',
                'iso_code' => 'LTU',
                'dial_code' => '370',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => 'LT(?:-)?[1-9][0-9]{4}',
            ),
            133 => 
            array (
                'id' => '134',
                'status' => '1',
                'order' => '1',
                'code' => 'LU',
                'name' => 'Luxembourg',
                'currency_code' => 'EUR',
                'north' => '50.184944',
                'south' => '49.446583',
                'east' => '6.528472',
                'west' => '5.734556',
                'capital_name' => 'Luxembourg',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'lb,de-LU,fr-LU',
                'iso_code' => 'LUX',
                'dial_code' => '352',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            134 => 
            array (
                'id' => '135',
                'status' => '1',
                'order' => '1',
                'code' => 'LV',
                'name' => 'Latvia',
                'currency_code' => 'EUR',
                'north' => '58.082306',
                'south' => '55.668861',
                'east' => '28.241167',
                'west' => '20.974277',
                'capital_name' => 'Riga',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'lv,ru,lt',
                'iso_code' => 'LVA',
                'dial_code' => '371',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => 'LV(?:-)?[1-9][0-9]{3}',
            ),
            135 => 
            array (
                'id' => '136',
                'status' => '1',
                'order' => '1',
                'code' => 'LY',
                'name' => 'Libya',
                'currency_code' => 'LYD',
                'north' => '33.168999',
                'south' => '19.508045',
                'east' => '25.150612',
                'west' => '9.38702',
                'capital_name' => 'Tripoli',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-LY,it,en',
                'iso_code' => 'LBY',
                'dial_code' => '218',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            136 => 
            array (
                'id' => '137',
                'status' => '1',
                'order' => '1',
                'code' => 'MA',
                'name' => 'Morocco',
                'currency_code' => 'MAD',
                'north' => '35.9224966985384',
                'south' => '27.662115',
                'east' => '-0.991750000000025',
                'west' => '-13.168586',
                'capital_name' => 'Rabat',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-MA,fr',
                'iso_code' => 'MAR',
                'dial_code' => '212',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            137 => 
            array (
                'id' => '138',
                'status' => '1',
                'order' => '1',
                'code' => 'MC',
                'name' => 'Monaco',
                'currency_code' => 'EUR',
                'north' => '43.75196717037228',
                'south' => '43.72472839869377',
                'east' => '7.439939260482788',
                'west' => '7.408962249755859',
                'capital_name' => 'Monaco',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'fr-MC,en,it',
                'iso_code' => 'MCO',
                'dial_code' => '377',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '980[0-9]{2}',
            ),
            138 => 
            array (
                'id' => '139',
                'status' => '1',
                'order' => '1',
                'code' => 'MD',
                'name' => 'Moldova',
                'currency_code' => 'MDL',
                'north' => '48.490166',
                'south' => '45.468887',
                'east' => '30.135445',
                'west' => '26.618944',
                'capital_name' => 'Chişinău',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'ro,ru,gag,tr',
                'iso_code' => 'MDA',
                'dial_code' => '373',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => 'MD(?:[-\\s])?[0-9]{4}',
            ),
            139 => 
            array (
                'id' => '140',
                'status' => '1',
                'order' => '1',
                'code' => 'ME',
                'name' => 'Montenegro',
                'currency_code' => 'EUR',
                'north' => '43.570137',
                'south' => '41.850166',
                'east' => '20.358833',
                'west' => '18.461306',
                'capital_name' => 'Podgorica',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sr,hu,bs,sq,hr,rom',
                'iso_code' => 'MNE',
                'dial_code' => '382',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            140 => 
            array (
                'id' => '141',
                'status' => '1',
                'order' => '1',
                'code' => 'MF',
                'name' => 'Saint Martin',
                'currency_code' => 'EUR',
                'north' => '18.130354',
                'south' => '18.052231',
                'east' => '-63.012993',
                'west' => '-63.152767',
                'capital_name' => 'Marigot',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'fr',
                'iso_code' => 'MAF',
                'dial_code' => '1',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '97150',
            ),
            141 => 
            array (
                'id' => '142',
                'status' => '1',
                'order' => '1',
                'code' => 'MG',
                'name' => 'Madagascar',
                'currency_code' => 'MGA',
                'north' => '-11.945433',
                'south' => '-25.608952',
                'east' => '50.48378',
                'west' => '43.224876',
                'capital_name' => 'Antananarivo',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-MG,mg',
                'iso_code' => 'MDG',
                'dial_code' => '261',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            142 => 
            array (
                'id' => '143',
                'status' => '1',
                'order' => '1',
                'code' => 'MH',
                'name' => 'Marshall Islands',
                'currency_code' => 'USD',
                'north' => '14.62',
                'south' => '5.587639',
                'east' => '171.931808',
                'west' => '165.524918',
                'capital_name' => 'Majuro',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'mh,en-MH',
                'iso_code' => 'MHL',
                'dial_code' => '692',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            143 => 
            array (
                'id' => '144',
                'status' => '1',
                'order' => '1',
                'code' => 'MK',
                'name' => 'Macedonia',
                'currency_code' => 'MKD',
                'north' => '42.361805',
                'south' => '40.860195',
                'east' => '23.038139',
                'west' => '20.464695',
                'capital_name' => 'Skopje',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'mk,sq,tr,rmm,sr',
                'iso_code' => 'MKD',
                'dial_code' => '389',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            144 => 
            array (
                'id' => '145',
                'status' => '1',
                'order' => '1',
                'code' => 'ML',
                'name' => 'Mali',
                'currency_code' => 'XOF',
                'north' => '25.000002',
                'south' => '10.159513',
                'east' => '4.244968',
                'west' => '-12.242614',
                'capital_name' => 'Bamako',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-ML,bm',
                'iso_code' => 'MLI',
                'dial_code' => '223',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            145 => 
            array (
                'id' => '146',
                'status' => '1',
                'order' => '1',
                'code' => 'MM',
                'name' => 'Myanmar [Burma]',
                'currency_code' => 'MMK',
                'north' => '28.543249',
                'south' => '9.784583',
                'east' => '101.176781',
                'west' => '92.189278',
                'capital_name' => 'Nay Pyi Taw',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'my',
                'iso_code' => 'MMR',
                'dial_code' => '95',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            146 => 
            array (
                'id' => '147',
                'status' => '1',
                'order' => '1',
                'code' => 'MN',
                'name' => 'Mongolia',
                'currency_code' => 'MNT',
                'north' => '52.154251',
                'south' => '41.567638',
                'east' => '119.924309',
                'west' => '87.749664',
                'capital_name' => 'Ulan Bator',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'mn,ru',
                'iso_code' => 'MNG',
                'dial_code' => '976',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            147 => 
            array (
                'id' => '148',
                'status' => '1',
                'order' => '1',
                'code' => 'MO',
                'name' => 'Macao',
                'currency_code' => 'MOP',
                'north' => '22.222334',
                'south' => '22.180389',
                'east' => '113.565834',
                'west' => '113.528946',
                'capital_name' => 'Macao',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'zh,zh-MO,pt',
                'iso_code' => 'MAC',
                'dial_code' => '853',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            148 => 
            array (
                'id' => '149',
                'status' => '1',
                'order' => '1',
                'code' => 'MP',
                'name' => 'Northern Mariana Islands',
                'currency_code' => 'USD',
                'north' => '20.55344',
                'south' => '14.11023',
                'east' => '146.06528',
                'west' => '144.88626',
                'capital_name' => 'Saipan',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'fil,tl,zh,ch-MP,en-MP',
                'iso_code' => 'MNP',
                'dial_code' => '1670',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            149 => 
            array (
                'id' => '150',
                'status' => '1',
                'order' => '1',
                'code' => 'MQ',
                'name' => 'Martinique',
                'currency_code' => 'EUR',
                'north' => '14.878819',
                'south' => '14.392262',
                'east' => '-60.81551',
                'west' => '-61.230118',
                'capital_name' => 'Fort-de-France',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'fr-MQ',
                'iso_code' => 'MTQ',
                'dial_code' => '596',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '972[0-9]{2}',
            ),
            150 => 
            array (
                'id' => '151',
                'status' => '1',
                'order' => '1',
                'code' => 'MR',
                'name' => 'Mauritania',
                'currency_code' => 'MRO',
                'north' => '27.298073',
                'south' => '14.715547',
                'east' => '-4.827674',
                'west' => '-17.066521',
                'capital_name' => 'Nouakchott',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-MR,fuc,snk,fr,mey,wo',
                'iso_code' => 'MRT',
                'dial_code' => '222',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            151 => 
            array (
                'id' => '152',
                'status' => '1',
                'order' => '1',
                'code' => 'MS',
                'name' => 'Montserrat',
                'currency_code' => 'XCD',
                'north' => '16.824060205313184',
                'south' => '16.674768935441556',
                'east' => '-62.144100129608205',
                'west' => '-62.24138237036129',
                'capital_name' => 'Plymouth',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-MS',
                'iso_code' => 'MSR',
                'dial_code' => '1664',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            152 => 
            array (
                'id' => '153',
                'status' => '1',
                'order' => '1',
                'code' => 'MT',
                'name' => 'Malta',
                'currency_code' => 'EUR',
                'north' => '36.0821530995456',
                'south' => '35.8061835000002',
                'east' => '14.5764915000002',
                'west' => '14.1834251000001',
                'capital_name' => 'Valletta',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'mt,en-MT',
                'iso_code' => 'MLT',
                'dial_code' => '356',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '[A-Z]{3}(?:[-\\s])?[0-9]{4}',
            ),
            153 => 
            array (
                'id' => '154',
                'status' => '1',
                'order' => '1',
                'code' => 'MU',
                'name' => 'Mauritius',
                'currency_code' => 'MUR',
                'north' => '-10.319255',
                'south' => '-20.525717',
                'east' => '63.500179',
                'west' => '56.512718',
                'capital_name' => 'Port Louis',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-MU,bho,fr',
                'iso_code' => 'MUS',
                'dial_code' => '230',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{4}',
            ),
            154 => 
            array (
                'id' => '155',
                'status' => '1',
                'order' => '1',
                'code' => 'MV',
                'name' => 'Maldives',
                'currency_code' => 'MVR',
                'north' => '7.091587495414767',
                'south' => '-0.692694',
                'east' => '73.637276',
                'west' => '72.693222',
                'capital_name' => 'Malé',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'dv,en',
                'iso_code' => 'MDV',
                'dial_code' => '960',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            155 => 
            array (
                'id' => '156',
                'status' => '1',
                'order' => '1',
                'code' => 'MW',
                'name' => 'Malawi',
                'currency_code' => 'MWK',
                'north' => '-9.367541',
                'south' => '-17.125',
                'east' => '35.916821',
                'west' => '32.67395',
                'capital_name' => 'Lilongwe',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ny,yao,tum,swk',
                'iso_code' => 'MWI',
                'dial_code' => '265',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            156 => 
            array (
                'id' => '157',
                'status' => '1',
                'order' => '1',
                'code' => 'MX',
                'name' => 'Mexico',
                'currency_code' => 'MXN',
                'north' => '32.716759',
                'south' => '14.532866',
                'east' => '-86.703392',
                'west' => '-118.453949',
                'capital_name' => 'Mexico City',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-MX',
                'iso_code' => 'MEX',
                'dial_code' => '52',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            157 => 
            array (
                'id' => '158',
                'status' => '1',
                'order' => '1',
                'code' => 'MY',
                'name' => 'Malaysia',
                'currency_code' => 'MYR',
                'north' => '7.363417',
                'south' => '0.855222',
                'east' => '119.267502',
                'west' => '99.643448',
                'capital_name' => 'Kuala Lumpur',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ms-MY,en,zh,ta,te,ml,pa,th',
                'iso_code' => 'MYS',
                'dial_code' => '60',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            158 => 
            array (
                'id' => '159',
                'status' => '1',
                'order' => '1',
                'code' => 'MZ',
                'name' => 'Mozambique',
                'currency_code' => 'MZN',
                'north' => '-10.471883',
                'south' => '-26.868685',
                'east' => '40.842995',
                'west' => '30.217319',
                'capital_name' => 'Maputo',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'pt-MZ,vmw',
                'iso_code' => 'MOZ',
                'dial_code' => '258',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            159 => 
            array (
                'id' => '160',
                'status' => '1',
                'order' => '1',
                'code' => 'NA',
                'name' => 'Namibia',
                'currency_code' => 'NAD',
                'north' => '-16.959894',
                'south' => '-28.97143',
                'east' => '25.256701',
                'west' => '11.71563',
                'capital_name' => 'Windhoek',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-NA,af,de,hz,naq',
                'iso_code' => 'NAM',
                'dial_code' => '264',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            160 => 
            array (
                'id' => '161',
                'status' => '1',
                'order' => '1',
                'code' => 'NC',
                'name' => 'New Caledonia',
                'currency_code' => 'XPF',
                'north' => '-19.549778',
                'south' => '-22.698',
                'east' => '168.129135',
                'west' => '163.564667',
                'capital_name' => 'Noumea',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'fr-NC',
                'iso_code' => 'NCL',
                'dial_code' => '687',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '988[0-9]{2}',
            ),
            161 => 
            array (
                'id' => '162',
                'status' => '1',
                'order' => '1',
                'code' => 'NE',
                'name' => 'Niger',
                'currency_code' => 'XOF',
                'north' => '23.525026',
                'south' => '11.696975',
                'east' => '15.995643',
                'west' => '0.16625',
                'capital_name' => 'Niamey',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-NE,ha,kr,dje',
                'iso_code' => 'NER',
                'dial_code' => '227',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            162 => 
            array (
                'id' => '163',
                'status' => '1',
                'order' => '1',
                'code' => 'NF',
                'name' => 'Norfolk Island',
                'currency_code' => 'AUD',
                'north' => '-28.995170686948427',
                'south' => '-29.063076742954735',
                'east' => '167.99773740209957',
                'west' => '167.91543230151365',
                'capital_name' => 'Kingston',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-NF',
                'iso_code' => 'NFK',
                'dial_code' => '672',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            163 => 
            array (
                'id' => '164',
                'status' => '1',
                'order' => '1',
                'code' => 'NG',
                'name' => 'Nigeria',
                'currency_code' => 'NGN',
                'north' => '13.892007',
                'south' => '4.277144',
                'east' => '14.680073',
                'west' => '2.668432',
                'capital_name' => 'Abuja',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-NG,ha,yo,ig,ff',
                'iso_code' => 'NGA',
                'dial_code' => '234',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            164 => 
            array (
                'id' => '165',
                'status' => '1',
                'order' => '1',
                'code' => 'NI',
                'name' => 'Nicaragua',
                'currency_code' => 'NIO',
                'north' => '15.025909',
                'south' => '10.707543',
                'east' => '-82.738289',
                'west' => '-87.690308',
                'capital_name' => 'Managua',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-NI,en',
                'iso_code' => 'NIC',
                'dial_code' => '505',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            165 => 
            array (
                'id' => '166',
                'status' => '1',
                'order' => '1',
                'code' => 'NL',
                'name' => 'Netherlands',
                'currency_code' => 'EUR',
                'north' => '53.512196',
                'south' => '50.753918',
                'east' => '7.227944',
                'west' => '3.362556',
                'capital_name' => 'Amsterdam',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'nl-NL,fy-NL',
                'iso_code' => 'NLD',
                'dial_code' => '31',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '([1-9][0-9]{3} [A-Z]{2})',
            ),
            166 => 
            array (
                'id' => '167',
                'status' => '1',
                'order' => '1',
                'code' => 'NO',
                'name' => 'Norway',
                'currency_code' => 'NOK',
                'north' => '71.18811',
                'south' => '57.977917',
                'east' => '31.078052520751953',
                'west' => '4.650167',
                'capital_name' => 'Oslo',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'no,nb,nn,se,fi',
                'iso_code' => 'NOR',
                'dial_code' => '47',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            167 => 
            array (
                'id' => '168',
                'status' => '1',
                'order' => '1',
                'code' => 'NP',
                'name' => 'Nepal',
                'currency_code' => 'NPR',
                'north' => '30.43339',
                'south' => '26.356722',
                'east' => '88.199333',
                'west' => '80.056274',
                'capital_name' => 'Kathmandu',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ne,en',
                'iso_code' => 'NPL',
                'dial_code' => '977',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            168 => 
            array (
                'id' => '169',
                'status' => '1',
                'order' => '1',
                'code' => 'NR',
                'name' => 'Nauru',
                'currency_code' => 'AUD',
                'north' => '-0.504306',
                'south' => '-0.552333',
                'east' => '166.945282',
                'west' => '166.899033',
                'capital_name' => '',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'na,en-NR',
                'iso_code' => 'NRU',
                'dial_code' => '674',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            169 => 
            array (
                'id' => '170',
                'status' => '1',
                'order' => '1',
                'code' => 'NU',
                'name' => 'Niue',
                'currency_code' => 'NZD',
                'north' => '-18.951069',
                'south' => '-19.152193',
                'east' => '-169.775177',
                'west' => '-169.951004',
                'capital_name' => 'Alofi',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'niu,en-NU',
                'iso_code' => 'NIU',
                'dial_code' => '683',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            170 => 
            array (
                'id' => '171',
                'status' => '1',
                'order' => '1',
                'code' => 'NZ',
                'name' => 'New Zealand',
                'currency_code' => 'NZD',
                'north' => '-34.389668',
                'south' => '-47.286026',
                'east' => '-180',
                'west' => '166.7155',
                'capital_name' => 'Wellington',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-NZ,mi',
                'iso_code' => 'NZL',
                'dial_code' => '64',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            171 => 
            array (
                'id' => '172',
                'status' => '1',
                'order' => '1',
                'code' => 'OM',
                'name' => 'Oman',
                'currency_code' => 'OMR',
                'north' => '26.387972',
                'south' => '16.64575',
                'east' => '59.836582',
                'west' => '51.882',
                'capital_name' => 'Muscat',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-OM,en,bal,ur',
                'iso_code' => 'OMN',
                'dial_code' => '968',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            172 => 
            array (
                'id' => '173',
                'status' => '1',
                'order' => '1',
                'code' => 'PA',
                'name' => 'Panama',
                'currency_code' => 'PAB',
                'north' => '9.637514',
                'south' => '7.197906',
                'east' => '-77.17411',
                'west' => '-83.051445',
                'capital_name' => 'Panama City',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-PA,en',
                'iso_code' => 'PAN',
                'dial_code' => '507',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{3}',
            ),
            173 => 
            array (
                'id' => '174',
                'status' => '1',
                'order' => '1',
                'code' => 'PE',
                'name' => 'Peru',
                'currency_code' => 'PEN',
                'north' => '-0.012977',
                'south' => '-18.349728',
                'east' => '-68.677986',
                'west' => '-81.326744',
                'capital_name' => 'Lima',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-PE,qu,ay',
                'iso_code' => 'PER',
                'dial_code' => '51',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '([0-9]{5})|(PE-[0-9]{5})',
            ),
            174 => 
            array (
                'id' => '175',
                'status' => '1',
                'order' => '1',
                'code' => 'PF',
                'name' => 'French Polynesia',
                'currency_code' => 'XPF',
                'north' => '-7.903573',
                'south' => '-27.653572',
                'east' => '-134.929825',
                'west' => '-152.877167',
                'capital_name' => 'Papeete',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'fr-PF,ty',
                'iso_code' => 'PYF',
                'dial_code' => '689',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '987[0-9]{2}',
            ),
            175 => 
            array (
                'id' => '176',
                'status' => '1',
                'order' => '1',
                'code' => 'PG',
                'name' => 'Papua New Guinea',
                'currency_code' => 'PGK',
                'north' => '-1.318639',
                'south' => '-11.657861',
                'east' => '155.96344',
                'west' => '140.842865',
                'capital_name' => 'Port Moresby',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-PG,ho,meu,tpi',
                'iso_code' => 'PNG',
                'dial_code' => '675',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            176 => 
            array (
                'id' => '177',
                'status' => '1',
                'order' => '1',
                'code' => 'PH',
                'name' => 'Philippines',
                'currency_code' => 'PHP',
                'north' => '21.120611',
                'south' => '4.643306',
                'east' => '126.601524',
                'west' => '116.931557',
                'capital_name' => 'Manila',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'tl,en-PH,fil',
                'iso_code' => 'PHL',
                'dial_code' => '63',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            177 => 
            array (
                'id' => '178',
                'status' => '1',
                'order' => '1',
                'code' => 'PK',
                'name' => 'Pakistan',
                'currency_code' => 'PKR',
                'north' => '37.097',
                'south' => '23.786722',
                'east' => '77.840919',
                'west' => '60.878613',
                'capital_name' => 'Islamabad',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ur-PK,en-PK,pa,sd,ps,brh',
                'iso_code' => 'PAK',
                'dial_code' => '92',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            178 => 
            array (
                'id' => '179',
                'status' => '1',
                'order' => '1',
                'code' => 'PL',
                'name' => 'Poland',
                'currency_code' => 'PLN',
                'north' => '54.839138',
                'south' => '49.006363',
                'east' => '24.150749',
                'west' => '14.123',
                'capital_name' => 'Warsaw',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'pl',
                'iso_code' => 'POL',
                'dial_code' => '48',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '([0-9])?[1-9][-][0-9]{3}',
            ),
            179 => 
            array (
                'id' => '180',
                'status' => '1',
                'order' => '1',
                'code' => 'PM',
                'name' => 'Saint Pierre and Miquelon',
                'currency_code' => 'EUR',
                'north' => '47.146286',
                'south' => '46.786041',
                'east' => '-56.252991',
                'west' => '-56.420658',
                'capital_name' => 'Saint-Pierre',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'fr-PM',
                'iso_code' => 'SPM',
                'dial_code' => '508',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '97500',
            ),
            180 => 
            array (
                'id' => '181',
                'status' => '1',
                'order' => '1',
                'code' => 'PN',
                'name' => 'Pitcairn Islands',
                'currency_code' => 'NZD',
                'north' => '-24.315865',
                'south' => '-24.672565',
                'east' => '-124.77285',
                'west' => '-128.346436',
                'capital_name' => 'Adamstown',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-PN',
                'iso_code' => 'PCN',
                'dial_code' => '64',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'PCRN 1ZZ',
            ),
            181 => 
            array (
                'id' => '182',
                'status' => '1',
                'order' => '1',
                'code' => 'PR',
                'name' => 'Puerto Rico',
                'currency_code' => 'USD',
                'north' => '18.520166',
                'south' => '17.926405',
                'east' => '-65.242737',
                'west' => '-67.942726',
                'capital_name' => 'San Juan',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-PR,es-PR',
                'iso_code' => 'PRI',
                'dial_code' => '1787',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            182 => 
            array (
                'id' => '183',
                'status' => '1',
                'order' => '1',
                'code' => 'PS',
                'name' => 'Palestine',
                'currency_code' => 'ILS',
                'north' => '32.54638671875',
                'south' => '31.216541290283203',
                'east' => '35.5732955932617',
                'west' => '34.21665954589844',
                'capital_name' => '',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-PS',
                'iso_code' => 'PSE',
                'dial_code' => '970',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}',
            ),
            183 => 
            array (
                'id' => '184',
                'status' => '1',
                'order' => '1',
                'code' => 'PT',
                'name' => 'Portugal',
                'currency_code' => 'EUR',
                'north' => '42.154311127408',
                'south' => '36.96125',
                'east' => '-6.18915930748288',
                'west' => '-9.50052660716588',
                'capital_name' => 'Lisbon',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'pt-PT,mwl',
                'iso_code' => 'PRT',
                'dial_code' => '351',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}[-\\s][1-9][0-9]{2}',
            ),
            184 => 
            array (
                'id' => '185',
                'status' => '1',
                'order' => '1',
                'code' => 'PW',
                'name' => 'Palau',
                'currency_code' => 'USD',
                'north' => '8.46966',
                'south' => '2.8036',
                'east' => '134.72307',
                'west' => '131.11788',
                'capital_name' => 'Melekeok - Palau State Capital',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'pau,sov,en-PW,tox,ja,fil,zh',
                'iso_code' => 'PLW',
                'dial_code' => '680',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            185 => 
            array (
                'id' => '186',
                'status' => '1',
                'order' => '1',
                'code' => 'PY',
                'name' => 'Paraguay',
                'currency_code' => 'PYG',
                'north' => '-19.294041',
                'south' => '-27.608738',
                'east' => '-54.259354',
                'west' => '-62.647076',
                'capital_name' => 'Asunción',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-PY,gn',
                'iso_code' => 'PRY',
                'dial_code' => '595',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            186 => 
            array (
                'id' => '187',
                'status' => '1',
                'order' => '1',
                'code' => 'QA',
                'name' => 'Qatar',
                'currency_code' => 'QAR',
                'north' => '26.154722',
                'south' => '24.482944',
                'east' => '51.636639',
                'west' => '50.757221',
                'capital_name' => 'Doha',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-QA,es',
                'iso_code' => 'QAT',
                'dial_code' => '974',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            187 => 
            array (
                'id' => '188',
                'status' => '1',
                'order' => '1',
                'code' => 'RE',
                'name' => 'Réunion',
                'currency_code' => 'EUR',
                'north' => '-20.868391324576944',
                'south' => '-21.383747301469107',
                'east' => '55.838193901930026',
                'west' => '55.21219224792685',
                'capital_name' => 'Saint-Denis',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-RE',
                'iso_code' => 'REU',
                'dial_code' => '262',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '974[0-9]{2}',
            ),
            188 => 
            array (
                'id' => '189',
                'status' => '1',
                'order' => '1',
                'code' => 'RO',
                'name' => 'Romania',
                'currency_code' => 'RON',
                'north' => '48.266945',
                'south' => '43.627304',
                'east' => '29.691055',
                'west' => '20.269972',
                'capital_name' => 'Bucharest',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'ro,hu,rom',
                'iso_code' => 'ROU',
                'dial_code' => '40',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            189 => 
            array (
                'id' => '190',
                'status' => '1',
                'order' => '1',
                'code' => 'RS',
                'name' => 'Serbia',
                'currency_code' => 'RSD',
                'north' => '46.18138885498047',
                'south' => '42.232215881347656',
                'east' => '23.00499725341797',
                'west' => '18.817020416259766',
                'capital_name' => 'Belgrade',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sr,hu,bs,rom',
                'iso_code' => 'SRB',
                'dial_code' => '381',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            190 => 
            array (
                'id' => '191',
                'status' => '1',
                'order' => '1',
                'code' => 'RU',
                'name' => 'Russia',
                'currency_code' => 'RUB',
                'north' => '81.857361',
                'south' => '41.188862',
                'east' => '-169.05',
                'west' => '19.25',
                'capital_name' => 'Moscow',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog',
                'iso_code' => 'RUS',
                'dial_code' => '70',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            191 => 
            array (
                'id' => '192',
                'status' => '1',
                'order' => '1',
                'code' => 'RW',
                'name' => 'Rwanda',
                'currency_code' => 'RWF',
                'north' => '-1.053481',
                'south' => '-2.840679',
                'east' => '30.895958',
                'west' => '28.856794',
                'capital_name' => 'Kigali',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'rw,en-RW,fr-RW,sw',
                'iso_code' => 'RWA',
                'dial_code' => '250',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            192 => 
            array (
                'id' => '193',
                'status' => '1',
                'order' => '1',
                'code' => 'SA',
                'name' => 'Saudi Arabia',
                'currency_code' => 'SAR',
                'north' => '32.158333',
                'south' => '15.61425',
                'east' => '55.666584',
                'west' => '34.495693',
                'capital_name' => 'Riyadh',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-SA',
                'iso_code' => 'SAU',
                'dial_code' => '966',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            193 => 
            array (
                'id' => '194',
                'status' => '1',
                'order' => '1',
                'code' => 'SB',
                'name' => 'Solomon Islands',
                'currency_code' => 'SBD',
                'north' => '-6.589611',
                'south' => '-11.850555',
                'east' => '166.980865',
                'west' => '155.508606',
                'capital_name' => 'Honiara',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-SB,tpi',
                'iso_code' => 'SLB',
                'dial_code' => '677',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            194 => 
            array (
                'id' => '195',
                'status' => '1',
                'order' => '1',
                'code' => 'SC',
                'name' => 'Seychelles',
                'currency_code' => 'SCR',
                'north' => '-4.283717',
                'south' => '-9.753867',
                'east' => '56.29770287937299',
                'west' => '46.204769',
                'capital_name' => 'Victoria',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-SC,fr-SC',
                'iso_code' => 'SYC',
                'dial_code' => '248',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            195 => 
            array (
                'id' => '196',
                'status' => '1',
                'order' => '1',
                'code' => 'SD',
                'name' => 'Sudan',
                'currency_code' => 'SDG',
                'north' => '22.232219696044922',
                'south' => '8.684720993041992',
                'east' => '38.60749816894531',
                'west' => '21.827774047851562',
                'capital_name' => 'Khartoum',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-SD,en,fia',
                'iso_code' => 'SDN',
                'dial_code' => '249',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            196 => 
            array (
                'id' => '197',
                'status' => '1',
                'order' => '1',
                'code' => 'SE',
                'name' => 'Sweden',
                'currency_code' => 'SEK',
                'north' => '69.0625',
                'south' => '55.337112',
                'east' => '24.1562924839185',
                'west' => '11.118694',
                'capital_name' => 'Stockholm',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sv-SE,se,sma,fi-SE',
                'iso_code' => 'SWE',
                'dial_code' => '46',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}[\\s]?[0-9]{2}',
            ),
            197 => 
            array (
                'id' => '198',
                'status' => '1',
                'order' => '1',
                'code' => 'SG',
                'name' => 'Singapore',
                'currency_code' => 'SGD',
                'north' => '1.471278',
                'south' => '1.258556',
                'east' => '104.007469',
                'west' => '103.638275',
                'capital_name' => 'Singapore',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'cmn,en-SG,ms-SG,ta-SG,zh-SG',
                'iso_code' => 'SGP',
                'dial_code' => '65',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            198 => 
            array (
                'id' => '199',
                'status' => '1',
                'order' => '1',
                'code' => 'SH',
                'name' => 'Saint Helena',
                'currency_code' => 'SHP',
                'north' => '-7.887815',
                'south' => '-16.019543',
                'east' => '-5.638753',
                'west' => '-14.42123',
                'capital_name' => 'Jamestown',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-SH',
                'iso_code' => 'SHN',
                'dial_code' => '290',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '(STHL 1ZZ)|(ASCN 1ZZ)|(TDCU 1ZZ)',
            ),
            199 => 
            array (
                'id' => '200',
                'status' => '1',
                'order' => '1',
                'code' => 'SI',
                'name' => 'Slovenia',
                'currency_code' => 'EUR',
                'north' => '46.8766275518195',
                'south' => '45.421812998164',
                'east' => '16.6106311807',
                'west' => '13.3753342064709',
                'capital_name' => 'Ljubljana',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sl,sh',
                'iso_code' => 'SVN',
                'dial_code' => '386',
                'is_eu' => '1',
                'has_postcodes' => '1',
            'regex' => '([0-9]{4})|(SI-[0-9]{4})',
            ),
            200 => 
            array (
                'id' => '201',
                'status' => '1',
                'order' => '1',
                'code' => 'SJ',
                'name' => 'Svalbard and Jan Mayen',
                'currency_code' => 'NOK',
                'north' => '80.762085',
                'south' => '79.220306',
                'east' => '33.287334',
                'west' => '17.699389',
                'capital_name' => 'Longyearbyen',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'no,ru',
                'iso_code' => 'SJM',
                'dial_code' => '47',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            201 => 
            array (
                'id' => '202',
                'status' => '1',
                'order' => '1',
                'code' => 'SK',
                'name' => 'Slovakia',
                'currency_code' => 'EUR',
                'north' => '49.603168',
                'south' => '47.728111',
                'east' => '22.570444',
                'west' => '16.84775',
                'capital_name' => 'Bratislava',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sk,hu',
                'iso_code' => 'SVK',
                'dial_code' => '421',
                'is_eu' => '1',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{2}[\\s][0-9]{2}',
            ),
            202 => 
            array (
                'id' => '203',
                'status' => '1',
                'order' => '1',
                'code' => 'SL',
                'name' => 'Sierra Leone',
                'currency_code' => 'SLL',
                'north' => '10',
                'south' => '6.929611',
                'east' => '-10.284238',
                'west' => '-13.307631',
                'capital_name' => 'Freetown',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-SL,men,tem',
                'iso_code' => 'SLE',
                'dial_code' => '232',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            203 => 
            array (
                'id' => '204',
                'status' => '1',
                'order' => '1',
                'code' => 'SM',
                'name' => 'San Marino',
                'currency_code' => 'EUR',
                'north' => '43.99223730851663',
                'south' => '43.8937092171425',
                'east' => '12.51653186779788',
                'west' => '12.403538978820734',
                'capital_name' => 'San Marino',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'it-SM',
                'iso_code' => 'SMR',
                'dial_code' => '378',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '4789[0-9]',
            ),
            204 => 
            array (
                'id' => '205',
                'status' => '1',
                'order' => '1',
                'code' => 'SN',
                'name' => 'Senegal',
                'currency_code' => 'XOF',
                'north' => '16.691633',
                'south' => '12.307275',
                'east' => '-11.355887',
                'west' => '-17.535236',
                'capital_name' => 'Dakar',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-SN,wo,fuc,mnk',
                'iso_code' => 'SEN',
                'dial_code' => '221',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            205 => 
            array (
                'id' => '206',
                'status' => '1',
                'order' => '1',
                'code' => 'SO',
                'name' => 'Somalia',
                'currency_code' => 'SOS',
                'north' => '11.979166',
                'south' => '-1.674868',
                'east' => '51.412636',
                'west' => '40.986595',
                'capital_name' => 'Mogadishu',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'so-SO,ar-SO,it,en-SO',
                'iso_code' => 'SOM',
                'dial_code' => '252',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[A-Z]{2}[-\\s][0-9]{5}',
            ),
            206 => 
            array (
                'id' => '207',
                'status' => '1',
                'order' => '1',
                'code' => 'SR',
                'name' => 'Suriname',
                'currency_code' => 'SRD',
                'north' => '6.004546',
                'south' => '1.831145',
                'east' => '-53.977493',
                'west' => '-58.086563',
                'capital_name' => 'Paramaribo',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'nl-SR,en,srn,hns,jv',
                'iso_code' => 'SUR',
                'dial_code' => '597',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            207 => 
            array (
                'id' => '208',
                'status' => '1',
                'order' => '1',
                'code' => 'SS',
                'name' => 'South Sudan',
                'currency_code' => 'SSP',
                'north' => '12.219148635864258',
                'south' => '3.493394374847412',
                'east' => '35.9405517578125',
                'west' => '24.140274047851562',
                'capital_name' => 'Juba',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en',
                'iso_code' => 'SSD',
                'dial_code' => '211',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            208 => 
            array (
                'id' => '209',
                'status' => '1',
                'order' => '1',
                'code' => 'ST',
                'name' => 'São Tomé and Príncipe',
                'currency_code' => 'STD',
                'north' => '1.701323',
                'south' => '0.024766',
                'east' => '7.466374',
                'west' => '6.47017',
                'capital_name' => 'São Tomé',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'pt-ST',
                'iso_code' => 'STP',
                'dial_code' => '239',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            209 => 
            array (
                'id' => '210',
                'status' => '1',
                'order' => '1',
                'code' => 'SV',
                'name' => 'El Salvador',
                'currency_code' => 'USD',
                'north' => '14.445067',
                'south' => '13.148679',
                'east' => '-87.692162',
                'west' => '-90.128662',
                'capital_name' => 'San Salvador',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'es-SV',
                'iso_code' => 'SLV',
                'dial_code' => '503',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            210 => 
            array (
                'id' => '211',
                'status' => '1',
                'order' => '1',
                'code' => 'SX',
                'name' => 'Sint Maarten',
                'currency_code' => 'ANG',
                'north' => '18.070248',
                'south' => '18.011692',
                'east' => '-63.012993',
                'west' => '-63.144039',
                'capital_name' => 'Philipsburg',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'nl,en',
                'iso_code' => 'SXM',
                'dial_code' => '1',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            211 => 
            array (
                'id' => '212',
                'status' => '1',
                'order' => '1',
                'code' => 'SY',
                'name' => 'Syria',
                'currency_code' => 'SYP',
                'north' => '37.319138',
                'south' => '32.310665',
                'east' => '42.385029',
                'west' => '35.727222',
                'capital_name' => 'Damascus',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-SY,ku,hy,arc,fr,en',
                'iso_code' => 'SYR',
                'dial_code' => '963',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            212 => 
            array (
                'id' => '213',
                'status' => '1',
                'order' => '1',
                'code' => 'SZ',
                'name' => 'Swaziland',
                'currency_code' => 'SZL',
                'north' => '-25.719648',
                'south' => '-27.317101',
                'east' => '32.13726',
                'west' => '30.794107',
                'capital_name' => 'Mbabane',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-SZ,ss-SZ',
                'iso_code' => 'SWZ',
                'dial_code' => '268',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[A-Z][0-9]{3}',
            ),
            213 => 
            array (
                'id' => '214',
                'status' => '1',
                'order' => '1',
                'code' => 'TC',
                'name' => 'Turks and Caicos Islands',
                'currency_code' => 'USD',
                'north' => '21.961878',
                'south' => '21.422626',
                'east' => '-71.123642',
                'west' => '-72.483871',
                'capital_name' => 'Cockburn Town',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-TC',
                'iso_code' => 'TCA',
                'dial_code' => '1649',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'TKCA 1ZZ',
            ),
            214 => 
            array (
                'id' => '215',
                'status' => '1',
                'order' => '1',
                'code' => 'TD',
                'name' => 'Chad',
                'currency_code' => 'XAF',
                'north' => '23.450369',
                'south' => '7.441068',
                'east' => '24.002661',
                'west' => '13.473475',
                'capital_name' => 'N\'Djamena',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-TD,ar-TD,sre',
                'iso_code' => 'TCD',
                'dial_code' => '235',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            215 => 
            array (
                'id' => '216',
                'status' => '1',
                'order' => '1',
                'code' => 'TF',
                'name' => 'French Southern Territories',
                'currency_code' => 'EUR',
                'north' => '-37.790722',
                'south' => '-49.735184',
                'east' => '77.598808',
                'west' => '50.170258',
                'capital_name' => 'Port-aux-Français',
                'continent_name' => 'Antarctica',
                'continent_code' => 'AN',
                'languages' => 'fr',
                'iso_code' => 'ATF',
                'dial_code' => '0',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            216 => 
            array (
                'id' => '217',
                'status' => '1',
                'order' => '1',
                'code' => 'TG',
                'name' => 'Togo',
                'currency_code' => 'XOF',
                'north' => '11.138977',
                'south' => '6.104417',
                'east' => '1.806693',
                'west' => '-0.147324',
                'capital_name' => 'Lomé',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-TG,ee,hna,kbp,dag,ha',
                'iso_code' => 'TGO',
                'dial_code' => '228',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            217 => 
            array (
                'id' => '218',
                'status' => '1',
                'order' => '1',
                'code' => 'TH',
                'name' => 'Thailand',
                'currency_code' => 'THB',
                'north' => '20.463194',
                'south' => '5.61',
                'east' => '105.639389',
                'west' => '97.345642',
                'capital_name' => 'Bangkok',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'th,en',
                'iso_code' => 'THA',
                'dial_code' => '66',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            218 => 
            array (
                'id' => '219',
                'status' => '1',
                'order' => '1',
                'code' => 'TJ',
                'name' => 'Tajikistan',
                'currency_code' => 'TJS',
                'north' => '41.042252',
                'south' => '36.674137',
                'east' => '75.137222',
                'west' => '67.387138',
                'capital_name' => 'Dushanbe',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'tg,ru',
                'iso_code' => 'TJK',
                'dial_code' => '992',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            219 => 
            array (
                'id' => '220',
                'status' => '1',
                'order' => '1',
                'code' => 'TK',
                'name' => 'Tokelau',
                'currency_code' => 'NZD',
                'north' => '-8.553613662719727',
                'south' => '-9.381111145019531',
                'east' => '-171.21142578125',
                'west' => '-172.50033569335938',
                'capital_name' => '',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'tkl,en-TK',
                'iso_code' => 'TKL',
                'dial_code' => '690',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            220 => 
            array (
                'id' => '221',
                'status' => '1',
                'order' => '1',
                'code' => 'TL',
                'name' => 'East Timor',
                'currency_code' => 'USD',
                'north' => '-8.135833740234375',
                'south' => '-9.463626861572266',
                'east' => '127.30859375',
                'west' => '124.04609680175781',
                'capital_name' => 'Dili',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'tet,pt-TL,id,en',
                'iso_code' => 'TLS',
                'dial_code' => '670',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            221 => 
            array (
                'id' => '222',
                'status' => '1',
                'order' => '1',
                'code' => 'TM',
                'name' => 'Turkmenistan',
                'currency_code' => 'TMT',
                'north' => '42.795555',
                'south' => '35.141083',
                'east' => '66.684303',
                'west' => '52.441444',
                'capital_name' => 'Ashgabat',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'tk,ru,uz',
                'iso_code' => 'TKM',
                'dial_code' => '7370',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            222 => 
            array (
                'id' => '223',
                'status' => '1',
                'order' => '1',
                'code' => 'TN',
                'name' => 'Tunisia',
                'currency_code' => 'TND',
                'north' => '37.543915',
                'south' => '30.240417',
                'east' => '11.598278',
                'west' => '7.524833',
                'capital_name' => 'Tunis',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'ar-TN,fr',
                'iso_code' => 'TUN',
                'dial_code' => '216',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{3}',
            ),
            223 => 
            array (
                'id' => '224',
                'status' => '1',
                'order' => '1',
                'code' => 'TO',
                'name' => 'Tonga',
                'currency_code' => 'TOP',
                'north' => '-15.562988',
                'south' => '-21.455057',
                'east' => '-173.907578',
                'west' => '-175.682266',
                'capital_name' => 'Nuku\'alofa',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'to,en-TO',
                'iso_code' => 'TON',
                'dial_code' => '676',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            224 => 
            array (
                'id' => '225',
                'status' => '1',
                'order' => '1',
                'code' => 'TR',
                'name' => 'Turkey',
                'currency_code' => 'TRY',
                'north' => '42.107613',
                'south' => '35.815418',
                'east' => '44.834999',
                'west' => '25.668501',
                'capital_name' => 'Ankara',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'tr-TR,ku,diq,az,av',
                'iso_code' => 'TUR',
                'dial_code' => '90',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            225 => 
            array (
                'id' => '226',
                'status' => '1',
                'order' => '1',
                'code' => 'TT',
                'name' => 'Trinidad and Tobago',
                'currency_code' => 'TTD',
                'north' => '11.338342',
                'south' => '10.036105',
                'east' => '-60.517933',
                'west' => '-61.923771',
                'capital_name' => 'Port of Spain',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-TT,hns,fr,es,zh',
                'iso_code' => 'TTO',
                'dial_code' => '1868',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{5}',
            ),
            226 => 
            array (
                'id' => '227',
                'status' => '1',
                'order' => '1',
                'code' => 'TV',
                'name' => 'Tuvalu',
                'currency_code' => 'AUD',
                'north' => '-5.641972',
                'south' => '-10.801169',
                'east' => '179.863281',
                'west' => '176.064865',
                'capital_name' => 'Funafuti',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'tvl,en,sm,gil',
                'iso_code' => 'TUV',
                'dial_code' => '688',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            227 => 
            array (
                'id' => '228',
                'status' => '1',
                'order' => '1',
                'code' => 'TW',
                'name' => 'Taiwan',
                'currency_code' => 'TWD',
                'north' => '25.3002899036181',
                'south' => '21.896606934717',
                'east' => '122.006739823315',
                'west' => '119.534691',
                'capital_name' => 'Taipei',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'zh-TW,zh,nan,hak',
                'iso_code' => 'TWN',
                'dial_code' => '886',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{3}(?:[-\\s][0-9]{2})?',
            ),
            228 => 
            array (
                'id' => '229',
                'status' => '1',
                'order' => '1',
                'code' => 'TZ',
                'name' => 'Tanzania',
                'currency_code' => 'TZS',
                'north' => '-0.990736',
                'south' => '-11.745696',
                'east' => '40.443222',
                'west' => '29.327168',
                'capital_name' => 'Dodoma',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'sw-TZ,en,ar',
                'iso_code' => 'TZA',
                'dial_code' => '255',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{4}',
            ),
            229 => 
            array (
                'id' => '230',
                'status' => '1',
                'order' => '1',
                'code' => 'UA',
                'name' => 'Ukraine',
                'currency_code' => 'UAH',
                'north' => '52.369362',
                'south' => '44.390415',
                'east' => '40.20739',
                'west' => '22.128889',
                'capital_name' => 'Kyiv',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'uk,ru-UA,rom,pl,hu',
                'iso_code' => 'UKR',
                'dial_code' => '380',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            230 => 
            array (
                'id' => '231',
                'status' => '1',
                'order' => '1',
                'code' => 'UG',
                'name' => 'Uganda',
                'currency_code' => 'UGX',
                'north' => '4.214427',
                'south' => '-1.48405',
                'east' => '35.036049',
                'west' => '29.573252',
                'capital_name' => 'Kampala',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-UG,lg,sw,ar',
                'iso_code' => 'UGA',
                'dial_code' => '256',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            231 => 
            array (
                'id' => '232',
                'status' => '1',
                'order' => '1',
                'code' => 'UM',
                'name' => 'U.S. Minor Outlying Islands',
                'currency_code' => 'USD',
                'north' => '28.219814',
                'south' => '-0.389006',
                'east' => '166.654526',
                'west' => '-177.392029',
                'capital_name' => '',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'en-UM',
                'iso_code' => 'UMI',
                'dial_code' => '1',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            232 => 
            array (
                'id' => '233',
                'status' => '1',
                'order' => '1',
                'code' => 'US',
                'name' => 'United States',
                'currency_code' => 'USD',
                'north' => '49.388611',
                'south' => '24.544245',
                'east' => '-66.954811',
                'west' => '-124.733253',
                'capital_name' => 'Washington',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-US,es-US,haw,fr',
                'iso_code' => 'USA',
                'dial_code' => '1',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            233 => 
            array (
                'id' => '234',
                'status' => '1',
                'order' => '1',
                'code' => 'UY',
                'name' => 'Uruguay',
                'currency_code' => 'UYU',
                'north' => '-30.082224',
                'south' => '-34.980816',
                'east' => '-53.073933',
                'west' => '-58.442722',
                'capital_name' => 'Montevideo',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-UY',
                'iso_code' => 'URY',
                'dial_code' => '598',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            234 => 
            array (
                'id' => '235',
                'status' => '1',
                'order' => '1',
                'code' => 'UZ',
                'name' => 'Uzbekistan',
                'currency_code' => 'UZS',
                'north' => '45.575001',
                'south' => '37.184444',
                'east' => '73.132278',
                'west' => '55.996639',
                'capital_name' => 'Tashkent',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'uz,ru,tg',
                'iso_code' => 'UZB',
                'dial_code' => '998',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            235 => 
            array (
                'id' => '236',
                'status' => '1',
                'order' => '1',
                'code' => 'VA',
                'name' => 'Vatican City',
                'currency_code' => 'EUR',
                'north' => '41.90743830885576',
                'south' => '41.90027960306854',
                'east' => '12.45837546629481',
                'west' => '12.44570678169205',
                'capital_name' => 'Vatican',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'la,it,fr',
                'iso_code' => 'VAT',
                'dial_code' => '39',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '00120',
            ),
            236 => 
            array (
                'id' => '237',
                'status' => '1',
                'order' => '1',
                'code' => 'VC',
                'name' => 'Saint Vincent and the Grenadines',
                'currency_code' => 'XCD',
                'north' => '13.377834',
                'south' => '12.583984810969037',
                'east' => '-61.11388',
                'west' => '-61.46090317727658',
                'capital_name' => 'Kingstown',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-VC,fr',
                'iso_code' => 'VCT',
                'dial_code' => '1784',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'VC[0-9]{4}',
            ),
            237 => 
            array (
                'id' => '238',
                'status' => '1',
                'order' => '1',
                'code' => 'VE',
                'name' => 'Venezuela',
                'currency_code' => 'VEF',
                'north' => '12.201903',
                'south' => '0.626311',
                'east' => '-59.80378',
                'west' => '-73.354073',
                'capital_name' => 'Caracas',
                'continent_name' => 'South America',
                'continent_code' => 'SA',
                'languages' => 'es-VE',
                'iso_code' => 'VEN',
                'dial_code' => '58',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '([0-9]{4})|([0-9]{4}[-][A-Z])',
            ),
            238 => 
            array (
                'id' => '239',
                'status' => '1',
                'order' => '1',
                'code' => 'VG',
                'name' => 'British Virgin Islands',
                'currency_code' => 'USD',
                'north' => '18.757221',
                'south' => '18.383710898211305',
                'east' => '-64.268768',
                'west' => '-64.71312752730364',
                'capital_name' => 'Road Town',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-VG',
                'iso_code' => 'VGB',
                'dial_code' => '1284',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'VG11[1-6]0',
            ),
            239 => 
            array (
                'id' => '240',
                'status' => '1',
                'order' => '1',
                'code' => 'VI',
                'name' => 'U.S. Virgin Islands',
                'currency_code' => 'USD',
                'north' => '18.415382',
                'south' => '17.673931',
                'east' => '-64.565193',
                'west' => '-65.101333',
                'capital_name' => 'Charlotte Amalie',
                'continent_name' => 'North America',
                'continent_code' => 'NA',
                'languages' => 'en-VI',
                'iso_code' => 'VIR',
                'dial_code' => '1340',
                'is_eu' => '0',
                'has_postcodes' => '1',
            'regex' => '[0-9]{5}(?:[-\\s][0-9]{4})?',
            ),
            240 => 
            array (
                'id' => '241',
                'status' => '1',
                'order' => '1',
                'code' => 'VN',
                'name' => 'Vietnam',
                'currency_code' => 'VND',
                'north' => '23.388834',
                'south' => '8.559611',
                'east' => '109.464638',
                'west' => '102.148224',
                'capital_name' => 'Hanoi',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'vi,en,fr,zh,km',
                'iso_code' => 'VNM',
                'dial_code' => '84',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{5}',
            ),
            241 => 
            array (
                'id' => '242',
                'status' => '1',
                'order' => '1',
                'code' => 'VU',
                'name' => 'Vanuatu',
                'currency_code' => 'VUV',
                'north' => '-13.073444',
                'south' => '-20.248945',
                'east' => '169.904785',
                'west' => '166.524979',
                'capital_name' => 'Port Vila',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'bi,en-VU,fr-VU',
                'iso_code' => 'VUT',
                'dial_code' => '678',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            242 => 
            array (
                'id' => '243',
                'status' => '1',
                'order' => '1',
                'code' => 'WF',
                'name' => 'Wallis and Futuna',
                'currency_code' => 'XPF',
                'north' => '-13.216758181061444',
                'south' => '-14.314559989820843',
                'east' => '-176.16174317718253',
                'west' => '-178.1848112896414',
                'capital_name' => 'Mata-Utu',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'wls,fud,fr-WF',
                'iso_code' => 'WLF',
                'dial_code' => '681',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '986[0-9]{2}',
            ),
            243 => 
            array (
                'id' => '244',
                'status' => '1',
                'order' => '1',
                'code' => 'WS',
                'name' => 'Samoa',
                'currency_code' => 'WST',
                'north' => '-13.432207',
                'south' => '-14.040939',
                'east' => '-171.415741',
                'west' => '-172.798599',
                'capital_name' => 'Apia',
                'continent_name' => 'Oceania',
                'continent_code' => 'OC',
                'languages' => 'sm,en-WS',
                'iso_code' => 'WSM',
                'dial_code' => '684',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => 'WS[0-9]{4}',
            ),
            244 => 
            array (
                'id' => '245',
                'status' => '1',
                'order' => '1',
                'code' => 'XK',
                'name' => 'Kosovo',
                'currency_code' => 'EUR',
                'north' => '43.2682495807952',
                'south' => '41.856369601859925',
                'east' => '21.80335088694943',
                'west' => '19.977481504492914',
                'capital_name' => 'Pristina',
                'continent_name' => 'Europe',
                'continent_code' => 'EU',
                'languages' => 'sq,sr',
                'iso_code' => 'XKX',
                'dial_code' => '383',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            245 => 
            array (
                'id' => '246',
                'status' => '1',
                'order' => '1',
                'code' => 'YE',
                'name' => 'Yemen',
                'currency_code' => 'YER',
                'north' => '18.9999989031009',
                'south' => '12.1110910264462',
                'east' => '54.5305388163283',
                'west' => '42.5325394314234',
                'capital_name' => 'Sanaa',
                'continent_name' => 'Asia',
                'continent_code' => 'AS',
                'languages' => 'ar-YE',
                'iso_code' => 'YEM',
                'dial_code' => '967',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
            246 => 
            array (
                'id' => '247',
                'status' => '1',
                'order' => '1',
                'code' => 'YT',
                'name' => 'Mayotte',
                'currency_code' => 'EUR',
                'north' => '-12.648891',
                'south' => '-13.000132',
                'east' => '45.29295',
                'west' => '45.03796',
                'capital_name' => 'Mamoutzou',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'fr-YT',
                'iso_code' => 'MYT',
                'dial_code' => '269',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '976[0-9]{2}',
            ),
            247 => 
            array (
                'id' => '248',
                'status' => '1',
                'order' => '1',
                'code' => 'ZA',
                'name' => 'South Africa',
                'currency_code' => 'ZAR',
                'north' => '-22.126612',
                'south' => '-34.839828',
                'east' => '32.895973',
                'west' => '16.458021',
                'capital_name' => 'Pretoria',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr',
                'iso_code' => 'ZAF',
                'dial_code' => '27',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => '[1-9][0-9]{3}',
            ),
            248 => 
            array (
                'id' => '249',
                'status' => '1',
                'order' => '1',
                'code' => 'ZM',
                'name' => 'Zambia',
                'currency_code' => 'ZMW',
                'north' => '-8.22436',
                'south' => '-18.079473',
                'east' => '33.705704',
                'west' => '21.999371',
                'capital_name' => 'Lusaka',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-ZM,bem,loz,lun,lue,ny,toi',
                'iso_code' => 'ZMB',
                'dial_code' => '260',
                'is_eu' => '0',
                'has_postcodes' => '1',
                'regex' => '[1-9][0-9]{4}',
            ),
            249 => 
            array (
                'id' => '250',
                'status' => '1',
                'order' => '1',
                'code' => 'ZW',
                'name' => 'Zimbabwe',
                'currency_code' => 'ZWL',
                'north' => '-15.608835',
                'south' => '-22.417738',
                'east' => '33.056305',
                'west' => '25.237028',
                'capital_name' => 'Harare',
                'continent_name' => 'Africa',
                'continent_code' => 'AF',
                'languages' => 'en-ZW,sn,nr,nd',
                'iso_code' => 'ZWE',
                'dial_code' => '263',
                'is_eu' => '0',
                'has_postcodes' => '0',
                'regex' => NULL,
            ),
        ));
        
        
    }
}