<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run() : void
    {
        $this->call(array_values(self::$tables));
        $this->call(AdminMenuTableSeeder::class);
        $this->call(PagesTableSeeder::class);
        $this->call(PageListTableSeeder::class);
        $this->call(PageListItemTableSeeder::class);
        $this->call(PageListItemDataTableSeeder::class);
        $this->call(PageOptionsTableSeeder::class);
        $this->call(SiteMenuTableSeeder::class);
    }

    /**
     * Define table names and corresponding seeders
     *
     * @var array|string[]
     */
    private static array $tables = [
        'languages' => LanguagesTableSeeder::class,
        'countries' => CountriesTableSeeder::class,
        'country_states' => CountryStatesTableSeeder::class,
        'currencies' => CurrenciesTableSeeder::class,
        'doctor_surgeries' => DoctorSurgeriesTableSeeder::class,
        'order_statuses' => OrderStatusesTableSeeder::class,
        'medical_conditions' => MedicalConditionsTableSeeder::class,
        'vat' => VatTableSeeder::class,
        'admin_menu' => AdminMenuTableSeeder::class,
        'admin_roles' => AdminRolesTableSeeder::class,
        'admin_role_permissions' => AdminRolePermissionsTableSeeder::class,
        'admin_users' => AdminUsersTableSeeder::class,
        'assessment_forms' => AssessmentFormsTableSeeder::class,
        'assessment_questions' => AssessmentQuestionsTableSeeder::class,
        'items' => ItemsTableSeeder::class,
        'assessment_qualifying_answers__group_templates' => AssessmentQualifyingAnswersGroupTemplatesTableSeeder::class,
        'assessment_qualifying_answers__groups_config' => AssessmentQualifyingAnswersGroupsConfigTableSeeder::class,
        'assessment_qualifying_answers__groups' => AssessmentQualifyingAnswersGroupsTableSeeder::class,
        'assessment_qualifying_answers' => AssessmentQualifyingAnswersTableSeeder::class,
        'categories' => CategoriesTableSeeder::class,
        'delivery_zones' => DeliveryZonesTableSeeder::class,
        'category_restricted_zones' => CategoryRestrictedZonesTableSeeder::class,
        'property_types' => PropertyTypesTableSeeder::class,
        'properties' => PropertiesTableSeeder::class,
        'custom_fields_sets' => CustomFieldsSetsTableSeeder::class,
        'custom_fields' => CustomFieldsTableSeeder::class,
        'custom_fields_sets_fields' => CustomFieldsSetsFieldsTableSeeder::class,
        'delivery_services_options' => DeliveryServicesOptionsTableSeeder::class,
        'delivery_methods' => DeliveryMethodsTableSeeder::class,
        'delivery_method_rates' => DeliveryMethodRatesTableSeeder::class,
        'incompatible_medications' => IncompatibleMedicationsTableSeeder::class,
        'ingredients' => IngredientsTableSeeder::class,
        'items_brands' => ItemsBrandsTableSeeder::class,
        'items_categories' => ItemsCategoriesTableSeeder::class,
        'items_complimented' => ItemsComplimentedTableSeeder::class,
        'items_custom' => ItemsCustomTableSeeder::class,
        'items_images' => ItemsImagesTableSeeder::class,
        'items_info' => ItemsInfoTableSeeder::class,
        'items_sizes' => ItemsSizesTableSeeder::class,
        'items_sizes_custom' => ItemsSizesCustomTableSeeder::class,
        'multisite__base_entities' => MultisiteBaseEntitiesTableSeeder::class,
        'pages' => PagesTableSeeder::class,
        'page_list' => PageListTableSeeder::class,
        'page_list_item' => PageListItemTableSeeder::class,
        'page_list_item_data' => PageListItemDataTableSeeder::class,
        'page_options' => PageOptionsTableSeeder::class,
        'placeholder_images' => PlaceholderImagesTableSeeder::class,
        'seo_defaults' => SeoDefaultsTableSeeder::class,
        'seo_settings' => SeoSettingsTableSeeder::class,
        'share_buttons' => ShareButtonsTableSeeder::class,
        'site_menu' => SiteMenuTableSeeder::class,
        'standard_template_letters' => StandardTemplateLettersTableSeeder::class,
        'static_blocks' => StaticBlocksTableSeeder::class,
        'static_blocks_instances' => StaticBlocksInstancesTableSeeder::class,
        'static_blocks_sizes' => StaticBlocksSizesTableSeeder::class,
        'subscription_preferences' => SubscriptionPreferencesTableSeeder::class,
    ];

    /**
     * Truncates tables before seeding
     */
    public function truncateTables()
    {
        // Reverse array so that we don't run into foreign key issues when deleting
        $tables = array_reverse(array_keys(self::$tables));
        foreach ($tables as $table) {
            DB::table($table)->delete();
        }
    }
}
