<?php

namespace Mtc\Plugins\Clinic\Src\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Shop\Assessment\Form;
use Mtc\Shop\Category;

/**
 * Accessors
 *
 * @property int $id
 * @property int|null $form_id
 * @property int|null $category_id
 * @property string $name
 * @property string $type
 * @property string $medium
 *
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @property Collection $reviews
 * @property Form $form
 * @property Category $category
 */
class ReviewType extends Model
{
    protected $table = 'review_types';

    protected $fillable = [
        'form_id',
        'category_id',
        'name',
        'type',
        'medium',
    ];

    /**
     * @return BelongsTo
     */
    public function form(): BelongsTo
    {
        return $this->belongsTo(Form::class, 'form_id');
    }

    /**
     * @return BelongsTo
     */
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}