const defaultReview = {
    id: null,
    status: 'unscheduled',
    member_id: null,
    users_id: null,
    form_id: null,
    category_id: null,
    medium: null,
    type: null,
    notes: '',
};

Vue.component('editReviewForm', {

    props: [
        'routes',
        'events',
        'reviewId',
        'isInline',
        'patientData',
        'parent',
    ],

    data: function() {
        return {
            component: 'review',
            review: defaultReview,
            loading: false,
            errors: {},
            success: false,
            reviewTypeIndex: null,
            dateOption: '',
            patient: {},
            patientQuery: '',
            patients: [],
            categories: [],
            reviewTypes: [],
            types: [],
            forms: [],
            users: [],
            mediums: [],
            statuses: [],
            assessments: [],
            dateOptions: [],
            showReview: false,
            eventIndex: 0,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        reviewTypeIndex(index) {
            if (index === null) {
                this.review = defaultReview;
                return;
            }
            let reviewType = this.reviewTypes[index];
            this.review.form_id = reviewType.form_id;
            this.review.category_id = reviewType.category_id;
            this.review.type = reviewType.type;
            this.review.medium = reviewType.medium;
        },
        dateOption(date) {
            this.review.due_date = date;
        },
        patientData(patient) {
            this.patient = patient;
        },
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'initReview') {
                    this.showReview = true;
                    this.loadReview(this.reviewId);
                }
                if (event.name === 'hideReview') {
                    this.showReview = false;
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        },
        reviewMedium(medium) {
            if (medium === 'video' || medium === 'phone') {
                this.review.status = 'unscheduled';
            } else if (medium === 'online') {
                this.review.status = 'pending';
            }
        },
    },

    computed: {
        showStatus() {
            return this.review.medium !== null && typeof this.review.medium !== 'undefined';
        },
        reviewMedium() {
            return this.review.medium;
        }
    },

    methods: {
        init() {
            if (!this.isInline) {
                return;
            }
            this.showReview = true;
            let reviewID = typeof this.reviewId !== 'undefined' ?
                this.reviewId :
                null;
            this.loadReview(reviewID);
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.review.due_date = $('#due_date').val();
            this.review.member_id = this.patient.id;

            this.$http.post(this.routes['admin-reviews-store'], { ...this.review })
                .then((response) => {
                    this.loading = false;

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                        vm.review = data.review;
                        vm.emitEvent('reviewsUpdated');
                    }
                });
        },
        searchPatients() {
            let vm = this;
            vm.success = false;
            vm.successText = '';
            vm.orderId = 0;
            this.$http.post(this.routes['admin-patients-search'], {
                query: this.patientQuery,
            }).then(function (response) {
                let data = response.data;
                if (data.success) {
                    vm.patients = data.patients;
                    return;
                }
                vm.errors = data.errors;
            });
        },
        loadReview(id) {
            let vm = this;
            vm.success = false;
            vm.successText = '';

            this.$http.post(this.routes['admin-reviews-load-review'], {
                id: typeof this.reviewId !== 'undefined' ?
                    this.reviewId :
                    null,
            })
                .then((response) => {

                    const data = response.data;

                    vm.categories = data.categories;
                    vm.reviewTypes = data.reviewTypes;
                    vm.types = data.types;
                    vm.forms = data.forms;
                    vm.mediums = data.mediums;
                    vm.statuses = data.statuses;
                    vm.users = data.users;
                    vm.dateOptions = data.dateOptions;
                    vm.review = data.review;
                    vm.assessments = data.review.assessments;

                    // New review and previous exists, we set the last prescriber
                    if (!vm.reviewId && data.lastReview !== null) {
                        vm.review.user_id = data.lastReview.user_id;
                    }

                    if (vm.reviewId) {

                        this.patient = this.review.member;

                        this.patient.firstname = this.patient.address_billing.firstname;
                        this.patient.lastname = this.patient.address_billing.lastname;
                        this.patient.address1 = this.patient.address_billing.address1;
                        this.patient.address2 = this.patient.address_billing.address2;
                        this.patient.city = this.patient.address_billing.city;
                        this.patient.postcode = this.patient.address_billing.postcode;
                    }
                });
        },

        selectPatient: function (patient) {
            this.patient = patient;
            this.review.member_id = patient.id;
            this.patients = [];
            this.patientQuery = '';
        },
        getPatientProfileURL(id) {
            return this.routes['admin-patients-profile'].replace('---id---', id);
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
