<?php
/**
 * EvoPay
 *
 * EvoPay is a payment gateway.
 * This integration allows processing payments through EvoPay
 * as well as refunding them if it is supported by the system
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\EvoPay\Classes;

use Illuminate\Support\Facades\Event;
use Mtc\Plugins\Refunds\Classes\Refund;
use Mtc\Shop\Order;

// Install if not yet installed
if (!defined('EVOPAY_ENABLED')) {
    require_once __DIR__ . '/admin/includes/install.php';
}

if (EVOPAY_ENABLED === true) {
    EvoPay::confirmComponentExists(Order::class, 'Shop');
    /*
     * Listen for the event where we attempt to load all available payment gateways.
     * This should be called in /shop/checkout/basket_overview.php
     * If this is a install on a pre-built site the event might not exist
     * and therefore you might need to check the latest version in the repo to update sites code.
     * This event returns an array which includes the template that
     * includes the form which will redirect user to the payment gateway.
     */
    Event::listen('shop.checkout.load_payment_gateways', '\\' . EvoPay::class . '@form');

    /*
     * Refunds functionality is disabled by default as not all sites will have this functionality
     * This also is depending on Refunds plugin existence.
     * If refunds are enabled all we need to do is enable the refund processing option
     * where we pass the refund method as the executor
     */
    if (EVOPAY_REFUNDS === true) {
        // Confirm refunds module exists
        EvoPay::confirmComponentExists(Refund::class, 'Refunds');

        Event::listen('refunds.get_refund_methods', function () {
            return [
                'id' => 'evopay',
                'name' => 'Refund with EvoPay',
                'callback' => '\\' . EvoPay::class . '::refund'
            ];
        });
    }

}


