<?php

namespace MtcPharmacy\Multisite\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Item as ShopItem;


class MultisiteCustomEntity extends Model
{
    protected $table = 'multisite__custom_entities';

    protected $fillable = [
        'parent_entity_id',
        'concrete_entity_id',
        'mode',
        'site_id',
    ];


    public function parent_entity()
    {
        return $this->belongsTo(MultisiteBaseEntity::class);
    }


    public function site()
    {
        return $this->belongsTo(MultisiteSite::class);
    }


    public function getConcreteEntity()
    {
        $concrete_entity = null;

        $concrete_class = $this->parent_entity->getConcreteClass();
        if ($concrete_class) {
            $concrete_entity = $concrete_class::find($this->concrete_entity_id);
        }

        if (! $concrete_entity) {
            throw new \Exception("Couldn't find concrete entity.");
        }

        return $concrete_entity;
    }
}
