
Vue.component('recommended-products', {

    props: [
        'variations',
        'recommendedItems',
        'questionId',
        'type',
    ],

    data: function() {
        return {
            items: [],
            recommended: {},
            foundItems: [],
            itemQuery: '',
            errors: [],
            success: false,
            successText: '',
            selectedVariation: null,
            successMessage: null
        };
    },

    mounted() {
        this.recommended = Object.keys(this.recommendedItems).length ?
            this.recommendedItems :
            {};
    },

    computed: {

        hasRecommended: function() {
            return Object.keys(this.recommended).length;
        },
        showProductSearch: function() {
            return this.selectedVariation !== null;
        },

    },

    methods: {

        searchItems: function () {
            let vm = this;
            vm.success = '';
            this.$http.post('/shop/admin/assessment/ajax.php', {
                action: 'searchItems',
                query: this.itemQuery,
            }).then(function (response) {
                let data = JSON.parse(response.data);
                if (data.success) {
                    vm.foundItems = data.items;
                    return;
                }
                vm.errors = data.errors;
            });
        },

        selectItem: function (item) {
            this.successMessage = null;
            if (!(this.selectedVariation in this.recommended)) {
                Vue.set(this.recommended, this.selectedVariation, {});
            }
            if (!(item.id in this.recommended[this.selectedVariation])) {
                let defaultIem = {
                    item_name: item.name,
                };
                if (item.size_id > 0) {
                    defaultIem.sizes = [];
                }
                Vue.set(this.recommended[this.selectedVariation], item.id, defaultIem);
            }

            if (item.size_id > 0) {
                let sizeFound = false;
                this.recommended[this.selectedVariation][item.id].sizes.forEach(attributes => {
                    if (attributes.size_id == item.size_id) {
                        sizeFound = true;
                    }
                });
                if (!sizeFound) {
                    let arraySize = this.recommended[this.selectedVariation][item.id].sizes.length;
                    Vue.set(this.recommended[this.selectedVariation][item.id].sizes, arraySize, {
                        size_id: item.size_id,
                        size_name: item.size,
                    });
                }

            }
        },

        removeItem: function (answer, item_id, size_id = null) {
            this.successMessage = null;
            if (size_id !== null) {
                let index = false;
                this.recommended[answer][item_id].sizes.forEach((attributes, key) => {
                    if (attributes.size_id == size_id) {
                        index = key;
                    }
                });
                if (index !== false) {
                    Vue.delete(this.recommended[answer][item_id].sizes, index);
                }
                if (Object.keys(this.recommended[answer][item_id].sizes).length > 0) {
                    return
                }
            }
            Vue.delete(this.recommended[answer], item_id);
            if (Object.keys(this.recommended[answer]).length === 0) {
                Vue.delete(this.recommended, answer);
            }
        },

        clearItemSearch: function() {
            this.itemQuery = '';
            this.foundItems = [];
        },

        saveRecommended: function () {
            this.successMessage = null;
            let vm = this;
            this.$http.post('/shop/admin/assessment/ajax.php', {
                action: 'save',
                recommended: this.recommended,
                questionId: this.questionId,
                type: this.type,
            }).then(function (response) {
                let data = JSON.parse(response.data);
                if (data.success) {
                    vm.successMessage = 'Data saved successfully';
                    return;
                }
                vm.errors = data.errors;
            });
        },
    },
});
