<?php

use Mtc\Shop\OrderStatusEmailText;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'page' => null,
]);

$page_meta['title'] = 'Manage Order Status Email Text';

if ($_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {
    OrderStatusEmailText::query()
        ->where('status_id', '=', $_REQUEST['delete_id'])
        ->delete();
}

require_once $path . 'core/admin/templates/adminheader.html.php';

$query = OrderStatusEmailText::query();
$totalnumrows = $query->count();

if ($_REQUEST['page'] == '') {
    $_REQUEST['page'] = 1;
}
$rowsPerPage = 25;
$pageNum = $_REQUEST['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;
$order_status_with_text = $query->limit($rowsPerPage)
    ->skip($offset)
    ->get()
    ->mapWithKeys(function ($item) {
        return [$item->status_id => $item->text];
    })
    ->toArray();
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1><?= clean_page($page_meta['title']) ?></h1>
<?php
include 'tabnav.php';

if (count($order_status_with_text) > 0) {
    ?>

    <p>Only text for status that will trigger an email can be edited here. Only status with text will show the delete option.</p>

    <table class="manage-items">
        <tr>
            <th>Status</th>
            <th class="center">Edit Text</th>
            <th class="center">Delete Text</th>
        </tr>
        <tbody class="tabular">
            <?php
            foreach ($order_status_with_text as $status_id => $status_name) {
                ?>
                <tr id="rorder-<?= $status_id ?>">
                    <td style="<?php
                    if (!in_array($status_id, array_keys($status_send_mail))) {
                        ?>color:#aaa;text-decoration:line-through<?php
                        }
                        ?>"><?= $status_name ?>
                    </td>
                    <td class="center">
                        <?php
                        if (in_array($status_id, array_keys($status_send_mail))) {
                            ?>
                            <a href="edit.php?id=<?= $status_id; ?>" class="edit picto"><i class="fa fa-pencil"></i></a>
                            <?php
                        }
                        ?>
                    </td>
                    <td class="center">
                        <?php
                        if (in_array($status_id, array_keys($status_send_mail))) {
                            ?>
                            <a href="manage.php?action=delete&delete_id=<?= $status_id; ?>"
                               class="alert picto error"
                               title="Are you sure you want to remove this text?">
                                <i class="fa fa-times-circle"></i>
                            </a>
                            <?php
                        }
                        ?>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
    <?php
} else {
    ?>
    <p>There are no order status</p>
    <?php
}

require_once $path . 'core/admin/templates/pagination.php';
require_once $path . 'core/admin/templates/adminfooter.html.php';
